/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;

public record SparseEmbeddingResults(List<Embedding> embeddings) implements EmbeddingResults<Embedding>
{
    public static final String NAME = "sparse_embedding_results";
    public static final String SPARSE_EMBEDDING = TaskType.SPARSE_EMBEDDING.toString();

    public SparseEmbeddingResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    public static SparseEmbeddingResults of(List<? extends InferenceResults> results) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>(results.size());
        for (InferenceResults inferenceResults : results) {
            if (inferenceResults instanceof TextExpansionResults) {
                TextExpansionResults expansionResults = (TextExpansionResults)inferenceResults;
                embeddings.add(Embedding.create(expansionResults.getWeightedTokens(), expansionResults.isTruncated()));
                continue;
            }
            if (inferenceResults instanceof ErrorInferenceResults) {
                ErrorInferenceResults errorResult = (ErrorInferenceResults)inferenceResults;
                Exception exception = errorResult.getException();
                if (exception instanceof ElasticsearchStatusException) {
                    ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
                    throw statusException;
                }
                throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, errorResult.getException(), new Object[0]);
            }
            throw new IllegalArgumentException("Received invalid legacy inference result, of type " + inferenceResults.getClass().getName() + " but expected SparseEmbeddingResults.");
        }
        return new SparseEmbeddingResults(embeddings);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).array(SPARSE_EMBEDDING, this.embeddings.iterator());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<Map> embeddingList = this.embeddings.stream().map(Embedding::asMap).toList();
        map.put(SPARSE_EMBEDDING, embeddingList);
        return map;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.transformToLegacyFormat();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        return this.embeddings.stream().map(embedding -> new TextExpansionResults("predicted_value", embedding.tokens().stream().map(weightedToken -> new WeightedToken(weightedToken.token(), weightedToken.weight())).toList(), embedding.isTruncated)).toList();
    }

    public record Embedding(List<WeightedToken> tokens, boolean isTruncated) implements Writeable,
    ToXContentObject,
    EmbeddingResults.Embedding<Embedding>
    {
        public static final String EMBEDDING = "embedding";
        public static final String IS_TRUNCATED = "is_truncated";

        public Embedding(StreamInput in) throws IOException {
            this(in.readCollectionAsList(WeightedToken::new), in.readBoolean());
        }

        public static Embedding create(List<WeightedToken> weightedTokens, boolean isTruncated) {
            return new Embedding(weightedTokens.stream().map(token -> new WeightedToken(token.token(), token.weight())).toList(), isTruncated);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.tokens);
            out.writeBoolean(this.isTruncated);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(IS_TRUNCATED, this.isTruncated);
            builder.startObject(EMBEDDING);
            for (WeightedToken weightedToken : this.tokens) {
                weightedToken.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Float> embeddingMap = new LinkedHashMap<String, Float>(this.tokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
            return new LinkedHashMap<String, Object>(Map.of(IS_TRUNCATED, this.isTruncated, EMBEDDING, embeddingMap));
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public Embedding merge(Embedding embedding) {
            ArrayList<WeightedToken> mergedTokens = new ArrayList<WeightedToken>();
            HashSet<String> seenTokens = new HashSet<String>();
            int i = 0;
            int j = 0;
            while (i < this.tokens().size() || j < embedding.tokens().size()) {
                WeightedToken token = i == this.tokens().size() ? embedding.tokens().get(j++) : (j == embedding.tokens().size() ? this.tokens().get(i++) : (this.tokens.get(i).weight() > embedding.tokens().get(j).weight() ? this.tokens().get(i++) : embedding.tokens().get(j++)));
                if (!seenTokens.add(token.token())) continue;
                mergedTokens.add(token);
            }
            boolean mergedIsTruncated = this.isTruncated || embedding.isTruncated();
            return new Embedding(mergedTokens, mergedIsTruncated);
        }

        @Override
        public BytesReference toBytesRef(XContent xContent) throws IOException {
            XContentBuilder b = XContentBuilder.builder(xContent);
            b.startObject();
            for (WeightedToken weightedToken : this.tokens) {
                weightedToken.toXContent(b, ToXContent.EMPTY_PARAMS);
            }
            b.endObject();
            return BytesReference.bytes(b);
        }
    }
}

