/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.RemoteClusterFeatureSetUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;

public class RemoteClusterUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public RemoteClusterUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(XPackUsageFeatureAction.REMOTE_CLUSTERS.name(), transportService, clusterService, threadPool, actionFilters);
    }

    @Override
    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) throws Exception {
        RemoteClusterService remoteClusterService = this.transportService.getRemoteClusterService();
        listener.onResponse(new XPackUsageFeatureResponse(new RemoteClusterFeatureSetUsage(remoteClusterService.getRemoteConnectionInfos().toList())));
    }
}

