/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model;

import java.util.List;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.Network;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.AbstractResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Continent;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Country;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.MaxMind;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.RepresentedCountry;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Traits;

public abstract class AbstractCountryResponse
extends AbstractResponse {
    private final Continent continent;
    private final Country country;
    private final Country registeredCountry;
    private final MaxMind maxmind;
    private final RepresentedCountry representedCountry;
    private final Traits traits;

    AbstractCountryResponse(Continent continent, Country country, MaxMind maxmind, Country registeredCountry, RepresentedCountry representedCountry, Traits traits) {
        this.continent = continent != null ? continent : new Continent();
        this.country = country != null ? country : new Country();
        this.registeredCountry = registeredCountry != null ? registeredCountry : new Country();
        this.maxmind = maxmind != null ? maxmind : new MaxMind();
        this.representedCountry = representedCountry != null ? representedCountry : new RepresentedCountry();
        this.traits = traits != null ? traits : new Traits();
    }

    AbstractCountryResponse(AbstractCountryResponse response, String ipAddress, Network network, List<String> locales) {
        this.continent = new Continent(response.getContinent(), locales);
        this.country = new Country(response.getCountry(), locales);
        this.maxmind = response.getMaxMind();
        this.registeredCountry = new Country(response.getRegisteredCountry(), locales);
        this.representedCountry = new RepresentedCountry(response.getRepresentedCountry(), locales);
        this.traits = new Traits(response.getTraits(), ipAddress, network);
    }

    @JsonProperty(value="maxmind")
    public MaxMind getMaxMind() {
        return this.maxmind;
    }

    @JsonProperty(value="registered_country")
    public Country getRegisteredCountry() {
        return this.registeredCountry;
    }

    public Continent getContinent() {
        return this.continent;
    }

    public Country getCountry() {
        return this.country;
    }

    @JsonProperty(value="represented_country")
    public RepresentedCountry getRepresentedCountry() {
        return this.representedCountry;
    }

    public Traits getTraits() {
        return this.traits;
    }
}

