/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.CombinedDocValues;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.elasticsearch.index.engine.SearchBasedChangesSnapshot;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.transport.Transports;

public final class LuceneChangesSnapshot
extends SearchBasedChangesSnapshot {
    private long lastSeenSeqNo;
    private int skippedOperations;
    private final boolean singleConsumer;
    private int docIndex = 0;
    private int maxDocIndex;
    private final ParallelArray parallelArray;
    private int storedFieldsReaderOrd = -1;
    private StoredFieldsReader storedFieldsReader = null;
    private final Thread creationThread = Assertions.ENABLED ? Thread.currentThread() : null;

    public LuceneChangesSnapshot(MapperService mapperService, Engine.Searcher engineSearcher, int searchBatchSize, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean singleConsumer, boolean accessStats, IndexVersion indexVersionCreated) throws IOException {
        super(mapperService, engineSearcher, searchBatchSize, fromSeqNo, toSeqNo, requiredFullRange, accessStats, indexVersionCreated);
        this.singleConsumer = singleConsumer;
        this.parallelArray = new ParallelArray(this.searchBatchSize);
        this.lastSeenSeqNo = fromSeqNo - 1L;
        TopDocs topDocs = this.nextTopDocs();
        this.maxDocIndex = topDocs.scoreDocs.length;
        this.fillParallelArray(topDocs.scoreDocs, this.parallelArray);
    }

    @Override
    public void close() throws IOException {
        assert (this.assertAccessingThread());
        super.close();
    }

    @Override
    public int totalOperations() {
        assert (this.assertAccessingThread());
        return super.totalOperations();
    }

    @Override
    public int skippedOperations() {
        assert (this.assertAccessingThread());
        return this.skippedOperations;
    }

    @Override
    protected Translog.Operation nextOperation() throws IOException {
        assert (this.assertAccessingThread());
        Translog.Operation op = null;
        int idx = this.nextDocIndex();
        while (idx != -1 && (op = this.readDocAsOp(idx)) == null) {
            idx = this.nextDocIndex();
        }
        return op;
    }

    private boolean assertAccessingThread() {
        assert (!this.singleConsumer || this.creationThread == Thread.currentThread()) : "created by [" + String.valueOf(this.creationThread) + "] != current thread [" + String.valueOf(Thread.currentThread()) + "]";
        assert (Transports.assertNotTransportThread("reading changes snapshot may involve slow IO"));
        return true;
    }

    private int nextDocIndex() throws IOException {
        if (this.docIndex == this.maxDocIndex && this.docIndex > 0) {
            ScoreDoc[] scoreDocs = this.nextTopDocs().scoreDocs;
            this.fillParallelArray(scoreDocs, this.parallelArray);
            this.docIndex = 0;
            this.maxDocIndex = scoreDocs.length;
        }
        if (this.docIndex < this.maxDocIndex) {
            int idx = this.docIndex++;
            return idx;
        }
        return -1;
    }

    private void fillParallelArray(ScoreDoc[] scoreDocs, ParallelArray parallelArray) throws IOException {
        if (scoreDocs.length > 0) {
            for (int i2 = 0; i2 < scoreDocs.length; ++i2) {
                scoreDocs[i2].shardIndex = i2;
            }
            boolean bl = parallelArray.useSequentialStoredFieldsReader = this.singleConsumer && scoreDocs.length >= 10 && LuceneChangesSnapshot.hasSequentialAccess(scoreDocs);
            if (!parallelArray.useSequentialStoredFieldsReader) {
                this.storedFieldsReaderOrd = -1;
                this.storedFieldsReader = null;
            }
            if (!parallelArray.useSequentialStoredFieldsReader) {
                ArrayUtil.introSort(scoreDocs, Comparator.comparingInt(i -> i.doc));
            }
            int docBase = -1;
            int maxDoc = 0;
            int readerIndex = 0;
            CombinedDocValues combinedDocValues = null;
            LeafReaderContext leaf = null;
            for (ScoreDoc scoreDoc : scoreDocs) {
                if (scoreDoc.doc >= docBase + maxDoc) {
                    while (scoreDoc.doc >= (docBase = leaf.docBase) + (maxDoc = (leaf = this.leaves().get(readerIndex++)).reader().maxDoc())) {
                    }
                    combinedDocValues = new CombinedDocValues(leaf.reader());
                }
                int segmentDocID = scoreDoc.doc - docBase;
                int index = scoreDoc.shardIndex;
                parallelArray.leafReaderContexts[index] = leaf;
                parallelArray.docID[index] = scoreDoc.doc;
                parallelArray.seqNo[index] = combinedDocValues.docSeqNo(segmentDocID);
                parallelArray.primaryTerm[index] = combinedDocValues.docPrimaryTerm(segmentDocID);
                parallelArray.version[index] = combinedDocValues.docVersion(segmentDocID);
                parallelArray.isTombStone[index] = combinedDocValues.isTombstone(segmentDocID);
                parallelArray.hasRecoverySource[index] = combinedDocValues.hasRecoverySource(segmentDocID);
            }
            if (!parallelArray.useSequentialStoredFieldsReader) {
                ArrayUtil.introSort(scoreDocs, Comparator.comparingInt(i -> i.shardIndex));
            }
        }
    }

    private static boolean hasSequentialAccess(ScoreDoc[] scoreDocs) {
        for (int i = 0; i < scoreDocs.length - 1; ++i) {
            if (scoreDocs[i].doc + 1 == scoreDocs[i + 1].doc) continue;
            return false;
        }
        return true;
    }

    static int countOperations(Engine.Searcher engineSearcher, long fromSeqNo, long toSeqNo, IndexVersion indexVersionCreated) throws IOException {
        if (fromSeqNo < 0L || toSeqNo < 0L || fromSeqNo > toSeqNo) {
            throw new IllegalArgumentException("Invalid range; from_seqno [" + fromSeqNo + "], to_seqno [" + toSeqNo + "]");
        }
        return LuceneChangesSnapshot.newIndexSearcher(engineSearcher).count(LuceneChangesSnapshot.rangeQuery(fromSeqNo, toSeqNo, indexVersionCreated));
    }

    private Translog.Operation readDocAsOp(int docIndex) throws IOException {
        Translog.Operation op;
        LeafReaderContext leaf = this.parallelArray.leafReaderContexts[docIndex];
        int segmentDocID = this.parallelArray.docID[docIndex] - leaf.docBase;
        long primaryTerm = this.parallelArray.primaryTerm[docIndex];
        assert (primaryTerm > 0L) : "nested child document must be excluded";
        long seqNo = this.parallelArray.seqNo[docIndex];
        if (seqNo == this.lastSeenSeqNo) {
            ++this.skippedOperations;
            return null;
        }
        long version = this.parallelArray.version[docIndex];
        String sourceField = this.parallelArray.hasRecoverySource[docIndex] ? "_recovery_source" : "_source";
        FieldsVisitor fields = new FieldsVisitor(true, sourceField);
        if (this.parallelArray.useSequentialStoredFieldsReader && this.storedFieldsReaderOrd != leaf.ord) {
            if (leaf.reader() instanceof SequentialStoredFieldsLeafReader) {
                this.storedFieldsReader = ((SequentialStoredFieldsLeafReader)leaf.reader()).getSequentialStoredFieldsReader();
                this.storedFieldsReaderOrd = leaf.ord;
                this.setNextSourceMetadataReader(leaf);
            } else {
                this.storedFieldsReader = null;
                this.storedFieldsReaderOrd = -1;
            }
        }
        if (this.storedFieldsReader != null) {
            assert (this.singleConsumer) : "Sequential access optimization must not be enabled for multiple consumers";
            assert (this.parallelArray.useSequentialStoredFieldsReader);
            assert (this.storedFieldsReaderOrd == leaf.ord) : this.storedFieldsReaderOrd + " != " + leaf.ord;
            this.storedFieldsReader.document(segmentDocID, fields);
        } else {
            this.setNextSourceMetadataReader(leaf);
            leaf.reader().document(segmentDocID, fields);
        }
        BytesReference source = fields.source() != null ? this.addSourceMetadata(fields.source(), segmentDocID) : null;
        boolean isTombstone = this.parallelArray.isTombStone[docIndex];
        if (isTombstone && fields.id() == null) {
            op = new Translog.NoOp(seqNo, primaryTerm, fields.source().utf8ToString());
            assert (version == 1L) : "Noop tombstone should have version 1L; actual version [" + version + "]";
            assert (LuceneChangesSnapshot.assertDocSoftDeleted(leaf.reader(), segmentDocID)) : "Noop but soft_deletes field is not set [" + String.valueOf(op) + "]";
        } else {
            String id = fields.id();
            if (isTombstone) {
                op = new Translog.Delete(id, seqNo, primaryTerm, version);
                assert (LuceneChangesSnapshot.assertDocSoftDeleted(leaf.reader(), segmentDocID)) : "Delete op but soft_deletes field is not set [" + String.valueOf(op) + "]";
            } else {
                if (source == null) {
                    if (this.requiredFullRange) {
                        throw new MissingHistoryOperationsException("source not found for seqno=" + seqNo + " from_seqno=" + this.fromSeqNo + " to_seqno=" + this.toSeqNo);
                    }
                    ++this.skippedOperations;
                    return null;
                }
                long autoGeneratedIdTimestamp = -1L;
                op = new Translog.Index(id, seqNo, primaryTerm, version, source, fields.routing(), -1L);
            }
        }
        assert (this.fromSeqNo <= op.seqNo() && op.seqNo() <= this.toSeqNo && this.lastSeenSeqNo < op.seqNo()) : "Unexpected operation; last_seen_seqno [" + this.lastSeenSeqNo + "], from_seqno [" + this.fromSeqNo + "], to_seqno [" + this.toSeqNo + "], op [" + String.valueOf(op) + "]";
        this.lastSeenSeqNo = op.seqNo();
        return op;
    }

    boolean useSequentialStoredFieldsReader() {
        return this.storedFieldsReader != null;
    }

    private static final class ParallelArray {
        final LeafReaderContext[] leafReaderContexts;
        final int[] docID;
        final long[] version;
        final long[] seqNo;
        final long[] primaryTerm;
        final boolean[] isTombStone;
        final boolean[] hasRecoverySource;
        boolean useSequentialStoredFieldsReader = false;

        ParallelArray(int size) {
            this.docID = new int[size];
            this.version = new long[size];
            this.seqNo = new long[size];
            this.primaryTerm = new long[size];
            this.isTombStone = new boolean[size];
            this.hasRecoverySource = new boolean[size];
            this.leafReaderContexts = new LeafReaderContext[size];
        }
    }
}

