/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class OverrideNodeVersionCommand
extends ElasticsearchNodeCommand {
    private static final String TOO_NEW_MESSAGE = "------------------------------------------------------------------------\n\nThis data path was last written by Elasticsearch version [V_NEW] and may no\nlonger be compatible with Elasticsearch version [V_CUR]. This tool will bypass\nthis compatibility check, allowing a version [V_CUR] node to start on this data\npath, but a version [V_CUR] node may not be able to read this data or may read\nit incorrectly leading to data loss.\n\nYou should not use this tool. Instead, continue to use a version [V_NEW] node\non this data path. If necessary, you can use reindex-from-remote to copy the\ndata from here into an older cluster.\n\nDo you want to proceed?\n";
    private static final String TOO_OLD_MESSAGE = "------------------------------------------------------------------------\n\nThis data path was last written by Elasticsearch version [V_OLD] which may be\ntoo old to be readable by Elasticsearch version [V_CUR].  This tool will bypass\nthis compatibility check, allowing a version [V_CUR] node to start on this data\npath, but this version [V_CUR] node may not be able to read this data or may\nread it incorrectly leading to data loss.\n\nYou should not use this tool. Instead, upgrade this data path from [V_OLD] to\n[V_CUR] using one or more intermediate versions of Elasticsearch.\n\nDo you want to proceed?\n";
    static final String NO_METADATA_MESSAGE = "no node metadata found, so there is no version to override";
    static final String SUCCESS_MESSAGE = "Successfully overwrote this node's metadata to bypass its version compatibility checks.";

    public OverrideNodeVersionCommand() {
        super("Overwrite the version stored in this node's data path with [" + String.valueOf(Version.CURRENT) + "] to bypass the version compatibility checks");
    }

    @Override
    protected void processDataPaths(Terminal terminal, Path[] paths, OptionSet options, Environment env) throws IOException {
        Path[] dataPaths = (Path[])Arrays.stream(OverrideNodeVersionCommand.toDataPaths(paths)).map(p -> p.path).toArray(Path[]::new);
        NodeMetadata nodeMetadata = PersistedClusterStateService.nodeMetadata(dataPaths);
        if (nodeMetadata == null) {
            throw new ElasticsearchException(NO_METADATA_MESSAGE, new Object[0]);
        }
        try {
            nodeMetadata.upgradeToCurrentVersion();
            throw new ElasticsearchException("found [" + String.valueOf(nodeMetadata) + "] which is compatible with current version [" + String.valueOf(Version.CURRENT) + "], so there is no need to override the version checks", new Object[0]);
        }
        catch (IllegalStateException illegalStateException) {
            OverrideNodeVersionCommand.confirm(terminal, (!nodeMetadata.nodeVersion().onOrAfterMinimumCompatible() ? TOO_OLD_MESSAGE : TOO_NEW_MESSAGE).replace("V_OLD", nodeMetadata.nodeVersion().toString()).replace("V_NEW", nodeMetadata.nodeVersion().toString()).replace("V_CUR", Version.CURRENT.toString()));
            PersistedClusterStateService.overrideVersion(Version.CURRENT, paths);
            terminal.println((CharSequence)SUCCESS_MESSAGE);
            return;
        }
    }

    OptionParser getParser() {
        return this.parser;
    }
}

