/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexingPressure;

public class IncrementalBulkService {
    public static final Setting<Boolean> INCREMENTAL_BULK = Setting.boolSetting("rest.incremental_bulk", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final Client client;
    private final AtomicBoolean enabledForTests = new AtomicBoolean(true);
    private final IndexingPressure indexingPressure;

    public IncrementalBulkService(Client client, IndexingPressure indexingPressure) {
        this.client = client;
        this.indexingPressure = indexingPressure;
    }

    public Handler newBulkRequest() {
        this.ensureEnabled();
        return this.newBulkRequest(null, null, null);
    }

    public Handler newBulkRequest(@Nullable String waitForActiveShards, @Nullable TimeValue timeout, @Nullable String refresh) {
        this.ensureEnabled();
        return new Handler(this.client, this.indexingPressure, waitForActiveShards, timeout, refresh);
    }

    private void ensureEnabled() {
        if (!this.enabledForTests.get()) {
            throw new AssertionError((Object)"Unexpected incremental bulk request");
        }
    }

    public void setForTests(boolean value) {
        this.enabledForTests.set(value);
    }

    public static class Handler
    implements Releasable {
        public static final BulkRequest.IncrementalState EMPTY_STATE = new BulkRequest.IncrementalState(Collections.emptyMap(), true);
        private final Client client;
        private final ActiveShardCount waitForActiveShards;
        private final TimeValue timeout;
        private final String refresh;
        private final ArrayList<Releasable> releasables = new ArrayList(4);
        private final ArrayList<BulkResponse> responses = new ArrayList(2);
        private final IndexingPressure.Incremental incrementalOperation;
        private boolean closed = false;
        private boolean globalFailure = false;
        private boolean incrementalRequestSubmitted = false;
        private boolean bulkInProgress = false;
        private Exception bulkActionLevelFailure = null;
        private BulkRequest bulkRequest = null;

        protected Handler(Client client, IndexingPressure indexingPressure, @Nullable String waitForActiveShards, @Nullable TimeValue timeout, @Nullable String refresh) {
            this.client = client;
            this.waitForActiveShards = waitForActiveShards != null ? ActiveShardCount.parseString(waitForActiveShards) : null;
            this.timeout = timeout;
            this.refresh = refresh;
            this.incrementalOperation = indexingPressure.startIncrementalCoordinating(0, 0L, false);
            this.createNewBulkRequest(EMPTY_STATE);
        }

        public IndexingPressure.Incremental getIncrementalOperation() {
            return this.incrementalOperation;
        }

        public void addItems(List<DocWriteRequest<?>> items, Releasable releasable, Runnable nextItems) {
            assert (!this.closed);
            assert (!this.bulkInProgress);
            if (this.bulkActionLevelFailure != null) {
                this.shortCircuitDueToTopLevelFailure(items, releasable);
                nextItems.run();
            } else {
                assert (this.bulkRequest != null);
                if (this.internalAddItems(items, releasable)) {
                    Optional<Releasable> maybeSplit = this.incrementalOperation.maybeSplit();
                    if (maybeSplit.isPresent()) {
                        Releasable coordinating = maybeSplit.get();
                        final boolean isFirstRequest = !this.incrementalRequestSubmitted;
                        this.incrementalRequestSubmitted = true;
                        ArrayList<Releasable> toRelease = new ArrayList<Releasable>(this.releasables);
                        this.releasables.clear();
                        this.bulkInProgress = true;
                        this.client.bulk(this.bulkRequest, ActionListener.runAfter(new ActionListener<BulkResponse>(){

                            @Override
                            public void onResponse(BulkResponse bulkResponse) {
                                this.handleBulkSuccess(bulkResponse);
                                this.createNewBulkRequest(new BulkRequest.IncrementalState(bulkResponse.getIncrementalState().shardLevelFailures(), true));
                            }

                            @Override
                            public void onFailure(Exception e) {
                                this.handleBulkFailure(isFirstRequest, e);
                            }
                        }, () -> {
                            this.bulkInProgress = false;
                            toRelease.forEach(Releasable::close);
                            coordinating.close();
                            nextItems.run();
                        }));
                    } else {
                        nextItems.run();
                    }
                } else {
                    nextItems.run();
                }
            }
        }

        public void lastItems(List<DocWriteRequest<?>> items, Releasable releasable, final ActionListener<BulkResponse> listener) {
            assert (!this.bulkInProgress);
            if (this.bulkActionLevelFailure != null) {
                this.shortCircuitDueToTopLevelFailure(items, releasable);
                this.errorResponse(listener);
            } else {
                assert (this.bulkRequest != null);
                if (this.internalAddItems(items, releasable)) {
                    Releasable coordinating = this.incrementalOperation.split();
                    ArrayList<Releasable> toRelease = new ArrayList<Releasable>(this.releasables);
                    this.releasables.clear();
                    this.bulkInProgress = true;
                    this.client.bulk(this.bulkRequest, ActionListener.runBefore(new ActionListener<BulkResponse>(){
                        private final boolean isFirstRequest;
                        {
                            this.isFirstRequest = !incrementalRequestSubmitted;
                        }

                        @Override
                        public void onResponse(BulkResponse bulkResponse) {
                            this.handleBulkSuccess(bulkResponse);
                            listener.onResponse(this.combineResponses());
                        }

                        @Override
                        public void onFailure(Exception e) {
                            this.handleBulkFailure(this.isFirstRequest, e);
                            this.errorResponse(listener);
                        }
                    }, () -> {
                        toRelease.forEach(Releasable::close);
                        coordinating.close();
                    }));
                } else {
                    this.errorResponse(listener);
                }
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.incrementalOperation.close();
                this.releasables.forEach(Releasable::close);
                this.releasables.clear();
            }
        }

        private void shortCircuitDueToTopLevelFailure(List<DocWriteRequest<?>> items, Releasable releasable) {
            assert (this.releasables.isEmpty());
            assert (this.incrementalOperation.currentOperationsSize() == 0L);
            assert (this.bulkRequest == null);
            if (!this.globalFailure) {
                this.addItemLevelFailures(items);
            }
            Releasables.close(releasable);
        }

        private void errorResponse(ActionListener<BulkResponse> listener) {
            if (this.globalFailure) {
                listener.onFailure(this.bulkActionLevelFailure);
            } else {
                listener.onResponse(this.combineResponses());
            }
        }

        private void handleBulkSuccess(BulkResponse bulkResponse) {
            this.responses.add(bulkResponse);
            this.bulkRequest = null;
        }

        private void handleBulkFailure(boolean isFirstRequest, Exception e) {
            assert (this.bulkActionLevelFailure == null);
            this.globalFailure = isFirstRequest;
            this.bulkActionLevelFailure = e;
            this.addItemLevelFailures(this.bulkRequest.requests());
            this.bulkRequest = null;
        }

        private void addItemLevelFailures(List<DocWriteRequest<?>> items) {
            BulkItemResponse[] bulkItemResponses = new BulkItemResponse[items.size()];
            int idx = 0;
            for (DocWriteRequest<?> item : items) {
                BulkItemResponse.Failure failure = new BulkItemResponse.Failure(item.index(), item.id(), this.bulkActionLevelFailure);
                bulkItemResponses[idx++] = BulkItemResponse.failure(idx, item.opType(), failure);
            }
            this.responses.add(new BulkResponse(bulkItemResponses, 0L, 0L));
        }

        private boolean internalAddItems(List<DocWriteRequest<?>> items, Releasable releasable) {
            try {
                this.bulkRequest.add(items);
                this.releasables.add(releasable);
                long size = items.stream().mapToLong(Accountable::ramBytesUsed).sum();
                this.incrementalOperation.increment(items.size(), size);
                return true;
            }
            catch (EsRejectedExecutionException e) {
                this.handleBulkFailure(!this.incrementalRequestSubmitted, e);
                this.incrementalOperation.split().close();
                this.releasables.forEach(Releasable::close);
                this.releasables.clear();
                return false;
            }
        }

        private void createNewBulkRequest(BulkRequest.IncrementalState incrementalState) {
            assert (this.bulkRequest == null);
            this.bulkRequest = new BulkRequest();
            this.bulkRequest.incrementalState(incrementalState);
            if (this.waitForActiveShards != null) {
                this.bulkRequest.waitForActiveShards(this.waitForActiveShards);
            }
            if (this.timeout != null) {
                this.bulkRequest.timeout(this.timeout);
            }
            if (this.refresh != null) {
                this.bulkRequest.setRefreshPolicy(this.refresh);
            }
        }

        private BulkResponse combineResponses() {
            long tookInMillis = 0L;
            long ingestTookInMillis = 0L;
            int itemResponseCount = 0;
            for (BulkResponse response : this.responses) {
                tookInMillis += response.getTookInMillis();
                ingestTookInMillis += response.getIngestTookInMillis();
                itemResponseCount += response.getItems().length;
            }
            BulkItemResponse[] bulkItemResponses = new BulkItemResponse[itemResponseCount];
            int i = 0;
            for (BulkResponse response : this.responses) {
                for (BulkItemResponse itemResponse : response.getItems()) {
                    bulkItemResponses[i++] = itemResponse;
                }
            }
            return new BulkResponse(bulkItemResponses, tookInMillis, ingestTookInMillis);
        }
    }

    public static class Enabled
    implements Supplier<Boolean> {
        private final AtomicBoolean incrementalBulksEnabled = new AtomicBoolean(true);

        public Enabled() {
        }

        public Enabled(ClusterSettings clusterSettings) {
            this.incrementalBulksEnabled.set(clusterSettings.get(INCREMENTAL_BULK));
            clusterSettings.addSettingsUpdateConsumer(INCREMENTAL_BULK, this.incrementalBulksEnabled::set);
        }

        @Override
        public Boolean get() {
            return this.incrementalBulksEnabled.get();
        }
    }
}

