/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestValue;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientRequestControl
extends Control {
    @NotNull
    public static final String INTERMEDIATE_CLIENT_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.2";
    private static final long serialVersionUID = 4883725840393001578L;
    @NotNull
    private final IntermediateClientRequestValue value;

    public IntermediateClientRequestControl(@Nullable IntermediateClientRequestValue downstreamRequest, @Nullable String downstreamClientAddress, @Nullable Boolean downstreamClientSecure, @Nullable String clientIdentity, @Nullable String clientName, @Nullable String clientSessionID, @Nullable String clientRequestID) {
        this(true, new IntermediateClientRequestValue(downstreamRequest, downstreamClientAddress, downstreamClientSecure, clientIdentity, clientName, clientSessionID, clientRequestID));
    }

    public IntermediateClientRequestControl(@NotNull IntermediateClientRequestValue value) {
        this(true, value);
    }

    public IntermediateClientRequestControl(boolean isCritical, @NotNull IntermediateClientRequestValue value) {
        super(INTERMEDIATE_CLIENT_REQUEST_OID, isCritical, new ASN1OctetString(value.encode().encode()));
        this.value = value;
    }

    public IntermediateClientRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Sequence valueSequence;
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CONTROL_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(controlValue.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CONTROL_VALUE_NOT_SEQUENCE.get(e), e);
        }
        this.value = IntermediateClientRequestValue.decode(valueSequence);
    }

    @NotNull
    public IntermediateClientRequestValue getRequestValue() {
        return this.value;
    }

    @Nullable
    public IntermediateClientRequestValue getDownstreamRequest() {
        return this.value.getDownstreamRequest();
    }

    @Nullable
    public String getClientIdentity() {
        return this.value.getClientIdentity();
    }

    @Nullable
    public String getDownstreamClientAddress() {
        return this.value.getDownstreamClientAddress();
    }

    @Nullable
    public Boolean downstreamClientSecure() {
        return this.value.downstreamClientSecure();
    }

    @Nullable
    public String getClientName() {
        return this.value.getClientName();
    }

    @Nullable
    public String getClientSessionID() {
        return this.value.getClientSessionID();
    }

    @Nullable
    public String getClientRequestID() {
        return this.value.getClientRequestID();
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IntermediateClientRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", value=");
        this.value.toString(buffer);
        buffer.append(')');
    }
}

