/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.repository_analyze;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.BlobDetails;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.SnapshotNodeInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DetailsInfo
implements JsonpSerializable {
    private final BlobDetails blob;
    @Nullable
    private final Time overwriteElapsed;
    @Nullable
    private final Long overwriteElapsedNanos;
    private final Time writeElapsed;
    private final long writeElapsedNanos;
    private final Time writeThrottled;
    private final long writeThrottledNanos;
    private final SnapshotNodeInfo writerNode;
    public static final JsonpDeserializer<DetailsInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DetailsInfo::setupDetailsInfoDeserializer);

    private DetailsInfo(Builder builder) {
        this.blob = ApiTypeHelper.requireNonNull(builder.blob, this, "blob");
        this.overwriteElapsed = builder.overwriteElapsed;
        this.overwriteElapsedNanos = builder.overwriteElapsedNanos;
        this.writeElapsed = ApiTypeHelper.requireNonNull(builder.writeElapsed, this, "writeElapsed");
        this.writeElapsedNanos = ApiTypeHelper.requireNonNull(builder.writeElapsedNanos, (Object)this, "writeElapsedNanos", 0L);
        this.writeThrottled = ApiTypeHelper.requireNonNull(builder.writeThrottled, this, "writeThrottled");
        this.writeThrottledNanos = ApiTypeHelper.requireNonNull(builder.writeThrottledNanos, (Object)this, "writeThrottledNanos", 0L);
        this.writerNode = ApiTypeHelper.requireNonNull(builder.writerNode, this, "writerNode");
    }

    public static DetailsInfo of(Function<Builder, ObjectBuilder<DetailsInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final BlobDetails blob() {
        return this.blob;
    }

    @Nullable
    public final Time overwriteElapsed() {
        return this.overwriteElapsed;
    }

    @Nullable
    public final Long overwriteElapsedNanos() {
        return this.overwriteElapsedNanos;
    }

    public final Time writeElapsed() {
        return this.writeElapsed;
    }

    public final long writeElapsedNanos() {
        return this.writeElapsedNanos;
    }

    public final Time writeThrottled() {
        return this.writeThrottled;
    }

    public final long writeThrottledNanos() {
        return this.writeThrottledNanos;
    }

    public final SnapshotNodeInfo writerNode() {
        return this.writerNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("blob");
        this.blob.serialize(generator, mapper);
        if (this.overwriteElapsed != null) {
            generator.writeKey("overwrite_elapsed");
            this.overwriteElapsed.serialize(generator, mapper);
        }
        if (this.overwriteElapsedNanos != null) {
            generator.writeKey("overwrite_elapsed_nanos");
            generator.write(this.overwriteElapsedNanos);
        }
        generator.writeKey("write_elapsed");
        this.writeElapsed.serialize(generator, mapper);
        generator.writeKey("write_elapsed_nanos");
        generator.write(this.writeElapsedNanos);
        generator.writeKey("write_throttled");
        this.writeThrottled.serialize(generator, mapper);
        generator.writeKey("write_throttled_nanos");
        generator.write(this.writeThrottledNanos);
        generator.writeKey("writer_node");
        this.writerNode.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDetailsInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::blob, BlobDetails._DESERIALIZER, "blob");
        op.add(Builder::overwriteElapsed, Time._DESERIALIZER, "overwrite_elapsed");
        op.add(Builder::overwriteElapsedNanos, JsonpDeserializer.longDeserializer(), "overwrite_elapsed_nanos");
        op.add(Builder::writeElapsed, Time._DESERIALIZER, "write_elapsed");
        op.add(Builder::writeElapsedNanos, JsonpDeserializer.longDeserializer(), "write_elapsed_nanos");
        op.add(Builder::writeThrottled, Time._DESERIALIZER, "write_throttled");
        op.add(Builder::writeThrottledNanos, JsonpDeserializer.longDeserializer(), "write_throttled_nanos");
        op.add(Builder::writerNode, SnapshotNodeInfo._DESERIALIZER, "writer_node");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DetailsInfo> {
        private BlobDetails blob;
        @Nullable
        private Time overwriteElapsed;
        @Nullable
        private Long overwriteElapsedNanos;
        private Time writeElapsed;
        private Long writeElapsedNanos;
        private Time writeThrottled;
        private Long writeThrottledNanos;
        private SnapshotNodeInfo writerNode;

        public final Builder blob(BlobDetails value) {
            this.blob = value;
            return this;
        }

        public final Builder blob(Function<BlobDetails.Builder, ObjectBuilder<BlobDetails>> fn) {
            return this.blob(fn.apply(new BlobDetails.Builder()).build());
        }

        public final Builder overwriteElapsed(@Nullable Time value) {
            this.overwriteElapsed = value;
            return this;
        }

        public final Builder overwriteElapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.overwriteElapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder overwriteElapsedNanos(@Nullable Long value) {
            this.overwriteElapsedNanos = value;
            return this;
        }

        public final Builder writeElapsed(Time value) {
            this.writeElapsed = value;
            return this;
        }

        public final Builder writeElapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.writeElapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder writeElapsedNanos(long value) {
            this.writeElapsedNanos = value;
            return this;
        }

        public final Builder writeThrottled(Time value) {
            this.writeThrottled = value;
            return this;
        }

        public final Builder writeThrottled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.writeThrottled(fn.apply(new Time.Builder()).build());
        }

        public final Builder writeThrottledNanos(long value) {
            this.writeThrottledNanos = value;
            return this;
        }

        public final Builder writerNode(SnapshotNodeInfo value) {
            this.writerNode = value;
            return this;
        }

        public final Builder writerNode(Function<SnapshotNodeInfo.Builder, ObjectBuilder<SnapshotNodeInfo>> fn) {
            return this.writerNode(fn.apply(new SnapshotNodeInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DetailsInfo build() {
            this._checkSingleUse();
            return new DetailsInfo(this);
        }
    }
}

