/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.ConnectorConfigProperties;
import co.elastic.clients.elasticsearch.connector.ConnectorFeatures;
import co.elastic.clients.elasticsearch.connector.ConnectorStatus;
import co.elastic.clients.elasticsearch.connector.CustomScheduling;
import co.elastic.clients.elasticsearch.connector.FilteringConfig;
import co.elastic.clients.elasticsearch.connector.IngestPipelineParams;
import co.elastic.clients.elasticsearch.connector.SchedulingConfiguration;
import co.elastic.clients.elasticsearch.connector.SyncStatus;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Connector
implements JsonpSerializable {
    @Nullable
    private final String apiKeyId;
    @Nullable
    private final String apiKeySecretId;
    private final Map<String, ConnectorConfigProperties> configuration;
    private final Map<String, CustomScheduling> customScheduling;
    @Nullable
    private final String description;
    @Nullable
    private final String error;
    @Nullable
    private final ConnectorFeatures features;
    private final List<FilteringConfig> filtering;
    @Nullable
    private final String id;
    @Nullable
    private final String indexName;
    private final boolean isNative;
    @Nullable
    private final String language;
    @Nullable
    private final String lastAccessControlSyncError;
    @Nullable
    private final DateTime lastAccessControlSyncScheduledAt;
    @Nullable
    private final SyncStatus lastAccessControlSyncStatus;
    @Nullable
    private final Long lastDeletedDocumentCount;
    @Nullable
    private final DateTime lastIncrementalSyncScheduledAt;
    @Nullable
    private final Long lastIndexedDocumentCount;
    @Nullable
    private final DateTime lastSeen;
    @Nullable
    private final String lastSyncError;
    @Nullable
    private final DateTime lastSyncScheduledAt;
    @Nullable
    private final SyncStatus lastSyncStatus;
    @Nullable
    private final DateTime lastSynced;
    @Nullable
    private final String name;
    @Nullable
    private final IngestPipelineParams pipeline;
    private final SchedulingConfiguration scheduling;
    @Nullable
    private final String serviceType;
    private final ConnectorStatus status;
    @Nullable
    private final JsonData syncCursor;
    private final boolean syncNow;
    public static final JsonpDeserializer<Connector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Connector::setupConnectorDeserializer);

    protected Connector(AbstractBuilder<?> builder) {
        this.apiKeyId = ((AbstractBuilder)builder).apiKeyId;
        this.apiKeySecretId = ((AbstractBuilder)builder).apiKeySecretId;
        this.configuration = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).configuration, (Object)this, "configuration");
        this.customScheduling = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).customScheduling, (Object)this, "customScheduling");
        this.description = ((AbstractBuilder)builder).description;
        this.error = ((AbstractBuilder)builder).error;
        this.features = ((AbstractBuilder)builder).features;
        this.filtering = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).filtering, (Object)this, "filtering");
        this.id = ((AbstractBuilder)builder).id;
        this.indexName = ((AbstractBuilder)builder).indexName;
        this.isNative = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).isNative, (Object)this, "isNative", false);
        this.language = ((AbstractBuilder)builder).language;
        this.lastAccessControlSyncError = ((AbstractBuilder)builder).lastAccessControlSyncError;
        this.lastAccessControlSyncScheduledAt = ((AbstractBuilder)builder).lastAccessControlSyncScheduledAt;
        this.lastAccessControlSyncStatus = ((AbstractBuilder)builder).lastAccessControlSyncStatus;
        this.lastDeletedDocumentCount = ((AbstractBuilder)builder).lastDeletedDocumentCount;
        this.lastIncrementalSyncScheduledAt = ((AbstractBuilder)builder).lastIncrementalSyncScheduledAt;
        this.lastIndexedDocumentCount = ((AbstractBuilder)builder).lastIndexedDocumentCount;
        this.lastSeen = ((AbstractBuilder)builder).lastSeen;
        this.lastSyncError = ((AbstractBuilder)builder).lastSyncError;
        this.lastSyncScheduledAt = ((AbstractBuilder)builder).lastSyncScheduledAt;
        this.lastSyncStatus = ((AbstractBuilder)builder).lastSyncStatus;
        this.lastSynced = ((AbstractBuilder)builder).lastSynced;
        this.name = ((AbstractBuilder)builder).name;
        this.pipeline = ((AbstractBuilder)builder).pipeline;
        this.scheduling = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).scheduling, this, "scheduling");
        this.serviceType = ((AbstractBuilder)builder).serviceType;
        this.status = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).status, this, "status");
        this.syncCursor = ((AbstractBuilder)builder).syncCursor;
        this.syncNow = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).syncNow, (Object)this, "syncNow", false);
    }

    public static Connector connectorOf(Function<Builder, ObjectBuilder<Connector>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String apiKeyId() {
        return this.apiKeyId;
    }

    @Nullable
    public final String apiKeySecretId() {
        return this.apiKeySecretId;
    }

    public final Map<String, ConnectorConfigProperties> configuration() {
        return this.configuration;
    }

    public final Map<String, CustomScheduling> customScheduling() {
        return this.customScheduling;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Nullable
    public final ConnectorFeatures features() {
        return this.features;
    }

    public final List<FilteringConfig> filtering() {
        return this.filtering;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String indexName() {
        return this.indexName;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final String lastAccessControlSyncError() {
        return this.lastAccessControlSyncError;
    }

    @Nullable
    public final DateTime lastAccessControlSyncScheduledAt() {
        return this.lastAccessControlSyncScheduledAt;
    }

    @Nullable
    public final SyncStatus lastAccessControlSyncStatus() {
        return this.lastAccessControlSyncStatus;
    }

    @Nullable
    public final Long lastDeletedDocumentCount() {
        return this.lastDeletedDocumentCount;
    }

    @Nullable
    public final DateTime lastIncrementalSyncScheduledAt() {
        return this.lastIncrementalSyncScheduledAt;
    }

    @Nullable
    public final Long lastIndexedDocumentCount() {
        return this.lastIndexedDocumentCount;
    }

    @Nullable
    public final DateTime lastSeen() {
        return this.lastSeen;
    }

    @Nullable
    public final String lastSyncError() {
        return this.lastSyncError;
    }

    @Nullable
    public final DateTime lastSyncScheduledAt() {
        return this.lastSyncScheduledAt;
    }

    @Nullable
    public final SyncStatus lastSyncStatus() {
        return this.lastSyncStatus;
    }

    @Nullable
    public final DateTime lastSynced() {
        return this.lastSynced;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final IngestPipelineParams pipeline() {
        return this.pipeline;
    }

    public final SchedulingConfiguration scheduling() {
        return this.scheduling;
    }

    @Nullable
    public final String serviceType() {
        return this.serviceType;
    }

    public final ConnectorStatus status() {
        return this.status;
    }

    @Nullable
    public final JsonData syncCursor() {
        return this.syncCursor;
    }

    public final boolean syncNow() {
        return this.syncNow;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.apiKeyId != null) {
            generator.writeKey("api_key_id");
            generator.write(this.apiKeyId);
        }
        if (this.apiKeySecretId != null) {
            generator.writeKey("api_key_secret_id");
            generator.write(this.apiKeySecretId);
        }
        if (ApiTypeHelper.isDefined(this.configuration)) {
            generator.writeKey("configuration");
            generator.writeStartObject();
            for (Map.Entry<String, ConnectorConfigProperties> entry : this.configuration.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.customScheduling)) {
            generator.writeKey("custom_scheduling");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.customScheduling.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CustomScheduling)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (this.features != null) {
            generator.writeKey("features");
            this.features.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.filtering)) {
            generator.writeKey("filtering");
            generator.writeStartArray();
            for (FilteringConfig filteringConfig : this.filtering) {
                filteringConfig.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.indexName != null) {
            generator.writeKey("index_name");
            generator.write(this.indexName);
        }
        generator.writeKey("is_native");
        generator.write(this.isNative);
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.lastAccessControlSyncError != null) {
            generator.writeKey("last_access_control_sync_error");
            generator.write(this.lastAccessControlSyncError);
        }
        if (this.lastAccessControlSyncScheduledAt != null) {
            generator.writeKey("last_access_control_sync_scheduled_at");
            this.lastAccessControlSyncScheduledAt.serialize(generator, mapper);
        }
        if (this.lastAccessControlSyncStatus != null) {
            generator.writeKey("last_access_control_sync_status");
            this.lastAccessControlSyncStatus.serialize(generator, mapper);
        }
        if (this.lastDeletedDocumentCount != null) {
            generator.writeKey("last_deleted_document_count");
            generator.write(this.lastDeletedDocumentCount);
        }
        if (this.lastIncrementalSyncScheduledAt != null) {
            generator.writeKey("last_incremental_sync_scheduled_at");
            this.lastIncrementalSyncScheduledAt.serialize(generator, mapper);
        }
        if (this.lastIndexedDocumentCount != null) {
            generator.writeKey("last_indexed_document_count");
            generator.write(this.lastIndexedDocumentCount);
        }
        if (this.lastSeen != null) {
            generator.writeKey("last_seen");
            this.lastSeen.serialize(generator, mapper);
        }
        if (this.lastSyncError != null) {
            generator.writeKey("last_sync_error");
            generator.write(this.lastSyncError);
        }
        if (this.lastSyncScheduledAt != null) {
            generator.writeKey("last_sync_scheduled_at");
            this.lastSyncScheduledAt.serialize(generator, mapper);
        }
        if (this.lastSyncStatus != null) {
            generator.writeKey("last_sync_status");
            this.lastSyncStatus.serialize(generator, mapper);
        }
        if (this.lastSynced != null) {
            generator.writeKey("last_synced");
            this.lastSynced.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            this.pipeline.serialize(generator, mapper);
        }
        generator.writeKey("scheduling");
        this.scheduling.serialize(generator, mapper);
        if (this.serviceType != null) {
            generator.writeKey("service_type");
            generator.write(this.serviceType);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.syncCursor != null) {
            generator.writeKey("sync_cursor");
            this.syncCursor.serialize(generator, mapper);
        }
        generator.writeKey("sync_now");
        generator.write(this.syncNow);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupConnectorDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::apiKeyId, JsonpDeserializer.stringDeserializer(), "api_key_id");
        op.add(AbstractBuilder::apiKeySecretId, JsonpDeserializer.stringDeserializer(), "api_key_secret_id");
        op.add(AbstractBuilder::configuration, JsonpDeserializer.stringMapDeserializer(ConnectorConfigProperties._DESERIALIZER), "configuration");
        op.add(AbstractBuilder::customScheduling, JsonpDeserializer.stringMapDeserializer(CustomScheduling._DESERIALIZER), "custom_scheduling");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(AbstractBuilder::features, ConnectorFeatures._DESERIALIZER, "features");
        op.add(AbstractBuilder::filtering, JsonpDeserializer.arrayDeserializer(FilteringConfig._DESERIALIZER), "filtering");
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(AbstractBuilder::isNative, JsonpDeserializer.booleanDeserializer(), "is_native");
        op.add(AbstractBuilder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(AbstractBuilder::lastAccessControlSyncError, JsonpDeserializer.stringDeserializer(), "last_access_control_sync_error");
        op.add(AbstractBuilder::lastAccessControlSyncScheduledAt, DateTime._DESERIALIZER, "last_access_control_sync_scheduled_at");
        op.add(AbstractBuilder::lastAccessControlSyncStatus, SyncStatus._DESERIALIZER, "last_access_control_sync_status");
        op.add(AbstractBuilder::lastDeletedDocumentCount, JsonpDeserializer.longDeserializer(), "last_deleted_document_count");
        op.add(AbstractBuilder::lastIncrementalSyncScheduledAt, DateTime._DESERIALIZER, "last_incremental_sync_scheduled_at");
        op.add(AbstractBuilder::lastIndexedDocumentCount, JsonpDeserializer.longDeserializer(), "last_indexed_document_count");
        op.add(AbstractBuilder::lastSeen, DateTime._DESERIALIZER, "last_seen");
        op.add(AbstractBuilder::lastSyncError, JsonpDeserializer.stringDeserializer(), "last_sync_error");
        op.add(AbstractBuilder::lastSyncScheduledAt, DateTime._DESERIALIZER, "last_sync_scheduled_at");
        op.add(AbstractBuilder::lastSyncStatus, SyncStatus._DESERIALIZER, "last_sync_status");
        op.add(AbstractBuilder::lastSynced, DateTime._DESERIALIZER, "last_synced");
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::pipeline, IngestPipelineParams._DESERIALIZER, "pipeline");
        op.add(AbstractBuilder::scheduling, SchedulingConfiguration._DESERIALIZER, "scheduling");
        op.add(AbstractBuilder::serviceType, JsonpDeserializer.stringDeserializer(), "service_type");
        op.add(AbstractBuilder::status, ConnectorStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::syncCursor, JsonData._DESERIALIZER, "sync_cursor");
        op.add(AbstractBuilder::syncNow, JsonpDeserializer.booleanDeserializer(), "sync_now");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String apiKeyId;
        @Nullable
        private String apiKeySecretId;
        private Map<String, ConnectorConfigProperties> configuration;
        private Map<String, CustomScheduling> customScheduling;
        @Nullable
        private String description;
        @Nullable
        private String error;
        @Nullable
        private ConnectorFeatures features;
        private List<FilteringConfig> filtering;
        @Nullable
        private String id;
        @Nullable
        private String indexName;
        private Boolean isNative;
        @Nullable
        private String language;
        @Nullable
        private String lastAccessControlSyncError;
        @Nullable
        private DateTime lastAccessControlSyncScheduledAt;
        @Nullable
        private SyncStatus lastAccessControlSyncStatus;
        @Nullable
        private Long lastDeletedDocumentCount;
        @Nullable
        private DateTime lastIncrementalSyncScheduledAt;
        @Nullable
        private Long lastIndexedDocumentCount;
        @Nullable
        private DateTime lastSeen;
        @Nullable
        private String lastSyncError;
        @Nullable
        private DateTime lastSyncScheduledAt;
        @Nullable
        private SyncStatus lastSyncStatus;
        @Nullable
        private DateTime lastSynced;
        @Nullable
        private String name;
        @Nullable
        private IngestPipelineParams pipeline;
        private SchedulingConfiguration scheduling;
        @Nullable
        private String serviceType;
        private ConnectorStatus status;
        @Nullable
        private JsonData syncCursor;
        private Boolean syncNow;

        public final BuilderT apiKeyId(@Nullable String value) {
            this.apiKeyId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT apiKeySecretId(@Nullable String value) {
            this.apiKeySecretId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT configuration(Map<String, ConnectorConfigProperties> map) {
            this.configuration = AbstractBuilder._mapPutAll(this.configuration, map);
            return (BuilderT)this.self();
        }

        public final BuilderT configuration(String key, ConnectorConfigProperties value) {
            this.configuration = AbstractBuilder._mapPut(this.configuration, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT configuration(String key, Function<ConnectorConfigProperties.Builder, ObjectBuilder<ConnectorConfigProperties>> fn) {
            return this.configuration(key, fn.apply(new ConnectorConfigProperties.Builder()).build());
        }

        public final BuilderT customScheduling(Map<String, CustomScheduling> map) {
            this.customScheduling = AbstractBuilder._mapPutAll(this.customScheduling, map);
            return (BuilderT)this.self();
        }

        public final BuilderT customScheduling(String key, CustomScheduling value) {
            this.customScheduling = AbstractBuilder._mapPut(this.customScheduling, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT customScheduling(String key, Function<CustomScheduling.Builder, ObjectBuilder<CustomScheduling>> fn) {
            return this.customScheduling(key, fn.apply(new CustomScheduling.Builder()).build());
        }

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT error(@Nullable String value) {
            this.error = value;
            return (BuilderT)this.self();
        }

        public final BuilderT features(@Nullable ConnectorFeatures value) {
            this.features = value;
            return (BuilderT)this.self();
        }

        public final BuilderT features(Function<ConnectorFeatures.Builder, ObjectBuilder<ConnectorFeatures>> fn) {
            return this.features(fn.apply(new ConnectorFeatures.Builder()).build());
        }

        public final BuilderT filtering(List<FilteringConfig> list) {
            this.filtering = AbstractBuilder._listAddAll(this.filtering, list);
            return (BuilderT)this.self();
        }

        public final BuilderT filtering(FilteringConfig value, FilteringConfig ... values) {
            this.filtering = AbstractBuilder._listAdd(this.filtering, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT filtering(Function<FilteringConfig.Builder, ObjectBuilder<FilteringConfig>> fn) {
            return this.filtering(fn.apply(new FilteringConfig.Builder()).build(), new FilteringConfig[0]);
        }

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT indexName(@Nullable String value) {
            this.indexName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isNative(boolean value) {
            this.isNative = value;
            return (BuilderT)this.self();
        }

        public final BuilderT language(@Nullable String value) {
            this.language = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastAccessControlSyncError(@Nullable String value) {
            this.lastAccessControlSyncError = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastAccessControlSyncScheduledAt(@Nullable DateTime value) {
            this.lastAccessControlSyncScheduledAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastAccessControlSyncStatus(@Nullable SyncStatus value) {
            this.lastAccessControlSyncStatus = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastDeletedDocumentCount(@Nullable Long value) {
            this.lastDeletedDocumentCount = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastIncrementalSyncScheduledAt(@Nullable DateTime value) {
            this.lastIncrementalSyncScheduledAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastIndexedDocumentCount(@Nullable Long value) {
            this.lastIndexedDocumentCount = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSeen(@Nullable DateTime value) {
            this.lastSeen = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSyncError(@Nullable String value) {
            this.lastSyncError = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSyncScheduledAt(@Nullable DateTime value) {
            this.lastSyncScheduledAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSyncStatus(@Nullable SyncStatus value) {
            this.lastSyncStatus = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSynced(@Nullable DateTime value) {
            this.lastSynced = value;
            return (BuilderT)this.self();
        }

        public final BuilderT name(@Nullable String value) {
            this.name = value;
            return (BuilderT)this.self();
        }

        public final BuilderT pipeline(@Nullable IngestPipelineParams value) {
            this.pipeline = value;
            return (BuilderT)this.self();
        }

        public final BuilderT pipeline(Function<IngestPipelineParams.Builder, ObjectBuilder<IngestPipelineParams>> fn) {
            return this.pipeline(fn.apply(new IngestPipelineParams.Builder()).build());
        }

        public final BuilderT scheduling(SchedulingConfiguration value) {
            this.scheduling = value;
            return (BuilderT)this.self();
        }

        public final BuilderT scheduling(Function<SchedulingConfiguration.Builder, ObjectBuilder<SchedulingConfiguration>> fn) {
            return this.scheduling(fn.apply(new SchedulingConfiguration.Builder()).build());
        }

        public final BuilderT serviceType(@Nullable String value) {
            this.serviceType = value;
            return (BuilderT)this.self();
        }

        public final BuilderT status(ConnectorStatus value) {
            this.status = value;
            return (BuilderT)this.self();
        }

        public final BuilderT syncCursor(@Nullable JsonData value) {
            this.syncCursor = value;
            return (BuilderT)this.self();
        }

        public final BuilderT syncNow(boolean value) {
            this.syncNow = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Connector> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Connector build() {
            this._checkSingleUse();
            return new Connector(this);
        }
    }
}

