"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockedWindows = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _constants2 = require("../../constants");
var _source_logic = require("../../source_logic");
var _blocked_window_item = require("./blocked_window_item");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BlockedWindows = () => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    schedule: {
      blockedWindows
    }
  } = (0, _kea.useValues)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    addBlockedWindow
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const hasBlockedWindows = blockedWindows && blockedWindows.length > 0;
  const emptyState = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "clock",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.BLOCKED_EMPTY_STATE_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _constants2.BLOCKED_EMPTY_STATE_DESCRIPTION),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: addBlockedWindow
    }, _constants.ADD_LABEL)
  }));
  const blockedWindowItems = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, blockedWindows === null || blockedWindows === void 0 ? void 0 : blockedWindows.map((blockedWindow, i) => /*#__PURE__*/_react.default.createElement(_blocked_window_item.BlockedWindowItem, {
    key: i,
    index: i,
    blockedWindow: blockedWindow
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: addBlockedWindow
  }, _constants.ADD_LABEL));
  return hasBlockedWindows ? blockedWindowItems : emptyState;
};
exports.BlockedWindows = BlockedWindows;