"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _kibana = require("../../../../shared/kibana");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _table_pagination = require("../../../../shared/table_pagination");
var _routes = require("../../../routes");
var _formatted_date_time = require("../../../utils/formatted_date_time");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _curations_logic = require("../curations_logic");
var _utils = require("../utils");
var _automated_icon = require("./automated_icon");
require("./curations_table.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationsTable = () => {
  const {
    dataLoading,
    curations,
    meta
  } = (0, _kea.useValues)(_curations_logic.CurationsLogic);
  const {
    onPaginate,
    deleteCuration
  } = (0, _kea.useActions)(_curations_logic.CurationsLogic);
  const columns = [{
    field: 'queries',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.column.queries', {
      defaultMessage: 'Queries'
    }),
    render: (queries, curation) => {
      var _curation$suggestion, _curation$suggestion2;
      return /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        "data-test-subj": "CurationsTableQueriesLink",
        to: (0, _engine.generateEnginePath)(_routes.ENGINE_CURATION_PATH, {
          curationId: curation.id
        })
      }, queries.join(', '), ((_curation$suggestion = curation.suggestion) === null || _curation$suggestion === void 0 ? void 0 : _curation$suggestion.status) === 'automated' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "accent",
        iconType: _automated_icon.AutomatedIcon,
        className: "curationsTableBadge"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.automatedLabel', {
        defaultMessage: 'Automated'
      }))), ((_curation$suggestion2 = curation.suggestion) === null || _curation$suggestion2 === void 0 ? void 0 : _curation$suggestion2.status) === 'pending' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        className: "curationsTableBadge"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.newSuggestionLabel', {
        defaultMessage: 'New suggestion'
      }))));
    },
    width: '40%',
    truncateText: true,
    mobileOptions: {
      header: true,
      enlarge: true,
      width: '100%'
    }
  }, {
    field: 'last_updated',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.column.lastUpdated', {
      defaultMessage: 'Last updated'
    }),
    width: '30%',
    dataType: 'string',
    render: dateString => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: (0, _utils.convertToDate)(dateString)
    })
  }, {
    width: '120px',
    actions: [{
      name: _constants.EDIT_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.editTooltip', {
        defaultMessage: 'Edit curation'
      }),
      type: 'icon',
      icon: 'pencil',
      color: 'primary',
      onClick: curation => {
        const {
          navigateToUrl
        } = _kibana.KibanaLogic.values;
        const url = (0, _engine.generateEnginePath)(_routes.ENGINE_CURATION_PATH, {
          curationId: curation.id
        });
        navigateToUrl(url);
      },
      'data-test-subj': 'CurationsTableEditButton'
    }, {
      name: _constants.DELETE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.deleteTooltip', {
        defaultMessage: 'Delete curation'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: curation => deleteCuration(curation.id),
      'data-test-subj': 'CurationsTableDeleteButton'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    className: "curationsTable",
    hasBorder: true,
    iconType: "package",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.table.title', {
      defaultMessage: 'Active curations'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: curations,
    loading: dataLoading,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  }));
};
exports.CurationsTable = CurationsTable;