"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantSpaceIdProvider = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireDefault(require("react"));
var _use_space_id = require("../../hooks/space_id/use_space_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantSpaceIdProvider = ({
  children
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  if (!spaceId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantSpaceIdProvider, {
    spaceId: spaceId
  }, children);
};
exports.AssistantSpaceIdProvider = AssistantSpaceIdProvider;