"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectTruncateStyles = void 0;
var _cache = _interopRequireDefault(require("@emotion/cache"));
var _css = require("@emotion/css");
var _serialize = require("@emotion/serialize");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The following emotion cache management was introduced here
 * https://ntsim.uk/posts/how-to-update-or-remove-global-styles-in-emotion/
 */
const TRUNCATE_GRADIENT_HEIGHT = 15;
const globalThemeCache = (0, _cache.default)({
  key: 'truncation'
});
const buildStylesheet = maxHeight => {
  if (!maxHeight) {
    return [`
    .dscTruncateByHeight {
      max-height: none;
    }`];
  }
  return [`
    .dscTruncateByHeight {
      overflow: hidden;
      max-height: ${maxHeight}px !important;
    }
    .dscTruncateByHeight:before {
      top: ${maxHeight - TRUNCATE_GRADIENT_HEIGHT}px;
    }
  `];
};
const injectTruncateStyles = maxHeight => {
  const serialized = (0, _serialize.serializeStyles)(buildStylesheet(maxHeight), _css.cache.registered);
  if (!globalThemeCache.inserted[serialized.name]) {
    globalThemeCache.insert('', serialized, globalThemeCache.sheet, true);
  }
};
exports.injectTruncateStyles = injectTruncateStyles;