"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternCellRenderer = void 0;
exports.getPatternCellRenderer = getPatternCellRenderer;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esqlUtils = require("@kbn/esql-utils");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PatternCellRenderer = ({
  pattern,
  isDetails,
  defaultRowHeight
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const keywords = (0, _react.useMemo)(() => (0, _esqlUtils.extractCategorizeTokens)(pattern), [pattern]);
  const containerStyle = (0, _react.useMemo)(() => getContainerStyle(defaultRowHeight), [defaultRowHeight]);
  const keywordStyle = (0, _react.useMemo)(() => ({
    marginRight: euiTheme.size.xs,
    marginBottom: `calc(${euiTheme.size.m} / 2)`,
    display: 'inline-block',
    padding: `${euiTheme.size.xxs} ${euiTheme.size.s}`,
    backgroundColor: euiTheme.colors.lightestShade,
    borderRadius: euiTheme.border.radius.small,
    color: euiTheme.colors.textPrimary,
    fontSize: euiTheme.size.m
  }), [euiTheme]);
  const detailsStyles = (0, _react.useMemo)(() => ({
    maxWidth: '600px'
  }), []);
  const formattedTokens = (0, _react.useMemo)(() => keywords.map((keyword, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      key: index,
      css: keywordStyle
    }, keyword);
  }), [keywordStyle, keywords]);
  if (isDetails) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: detailsStyles
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.contextAwareness.patternCellRenderer.tokensLabel",
      defaultMessage: "Tokens"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), formattedTokens), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.contextAwareness.patternCellRenderer.regexLabel",
      defaultMessage: "Regex"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "euiDataGridExpansionPopover-patternRegex"
    }, pattern)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: containerStyle
  }, formattedTokens);
};
exports.PatternCellRenderer = PatternCellRenderer;
function getPatternCellRenderer(row, columnId, isDetails, defaultRowHeight) {
  const pattern = row.flattened[columnId];
  if (pattern === undefined) {
    return '-';
  }
  return /*#__PURE__*/_react.default.createElement(PatternCellRenderer, {
    pattern: String(pattern),
    isDetails: isDetails,
    defaultRowHeight: defaultRowHeight
  });
}
function getContainerStyle(defaultRowHeight) {
  // the keywords are slightly larger than the default text height,
  // so they need to be adjusted to fit within the row height while
  // not truncating the bottom of the text
  let rowHeight = 2;
  if (defaultRowHeight === undefined) {
    rowHeight = 2;
  } else if (defaultRowHeight < 2) {
    rowHeight = 1;
  } else {
    rowHeight = Math.floor(defaultRowHeight / 1.5);
  }
  return {
    display: '-webkit-box',
    WebkitBoxOrient: 'vertical',
    WebkitLineClamp: rowHeight,
    overflow: 'hidden',
    textOverflow: 'ellipsis'
  };
}