"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchClientsMetricsCollector = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ElasticsearchClientsMetricsCollector {
  constructor(agentStatsProvider) {
    this.agentStatsProvider = agentStatsProvider;
  }
  async collect() {
    return await this.agentStatsProvider.getAgentsStats();
  }
  reset() {
    // we do not have a state in this Collector, aka metrics are not accumulated over time.
    // Thus, we don't need to perform any cleanup to reset the collected metrics
  }
}
exports.ElasticsearchClientsMetricsCollector = ElasticsearchClientsMetricsCollector;