"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileMainStatisticsByField = getMobileMainStatisticsByField;
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _latency_aggregation_type = require("../../lib/helpers/latency_aggregation_type");
var _latency_aggregation_types = require("../../../common/latency_aggregation_types");
var _calculate_throughput = require("../../lib/helpers/calculate_throughput");
var _document_type = require("../../../common/document_type");
var _rollup = require("../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileMainStatisticsByField({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  field
}) {
  async function getMobileTransactionEventStatistics() {
    var _response$aggregation, _response$aggregation2;
    const response = await apmEventClient.search(`get_mobile_transaction_events_main_statistics_by_field`, {
      apm: {
        sources: [{
          documentType: _document_type.ApmDocumentType.TransactionEvent,
          rollupInterval: _rollup.RollupInterval.None
        }]
      },
      body: {
        track_total_hits: false,
        size: 0,
        query: {
          bool: {
            filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
          }
        },
        aggs: {
          main_statistics: {
            terms: {
              field,
              size: 1000
            },
            aggs: {
              latency: {
                avg: {
                  field: _apm.TRANSACTION_DURATION
                }
              },
              sessions: {
                cardinality: {
                  field: _apm.SESSION_ID
                }
              }
            }
          }
        }
      }
    });
    return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.main_statistics.buckets.map(bucket => {
      return {
        name: bucket.key,
        latency: (0, _latency_aggregation_type.getLatencyValue)({
          latencyAggregationType: _latency_aggregation_types.LatencyAggregationType.avg,
          aggregation: bucket.latency
        }),
        throughput: (0, _calculate_throughput.calculateThroughputWithRange)({
          start,
          end,
          value: bucket.doc_count
        }),
        sessions: bucket.sessions.value
      };
    })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  }
  async function getMobileErrorEventStatistics() {
    var _response$aggregation3, _response$aggregation4;
    const response = await apmEventClient.search(`get_mobile_crashes`, {
      apm: {
        sources: [{
          documentType: _document_type.ApmDocumentType.ErrorEvent,
          rollupInterval: _rollup.RollupInterval.None
        }]
      },
      body: {
        track_total_hits: false,
        size: 0,
        query: {
          bool: {
            filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
          }
        },
        aggs: {
          main_statistics: {
            terms: {
              field,
              size: 1000
            },
            aggs: {
              crashes: {
                filter: {
                  term: {
                    [_apm.ERROR_TYPE]: 'crash'
                  }
                }
              }
            }
          }
        }
      }
    });
    return (_response$aggregation3 = (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.main_statistics.buckets.map(bucket => {
      var _bucket$crashes$doc_c;
      return {
        name: bucket.key,
        crashes: (_bucket$crashes$doc_c = bucket.crashes.doc_count) !== null && _bucket$crashes$doc_c !== void 0 ? _bucket$crashes$doc_c : 0
      };
    })) !== null && _response$aggregation3 !== void 0 ? _response$aggregation3 : [];
  }
  const [transactioEventStatistics, errorEventStatistics] = await Promise.all([getMobileTransactionEventStatistics(), getMobileErrorEventStatistics()]);
  const mainStatisticsMerged = (0, _lodash.merge)(transactioEventStatistics, errorEventStatistics);
  const mainStatistics = mainStatisticsMerged.map(item => {
    return {
      name: item.name,
      latency: item.latency,
      throughput: item.throughput,
      crashRate: item.crashes ? item.crashes / item.sessions : 0
    };
  });
  return {
    mainStatistics
  };
}