"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseContext = void 0;
exports.LicenseProvider = LicenseProvider;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
var _invalid_license_notification = require("./invalid_license_notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicenseContext = exports.LicenseContext = /*#__PURE__*/_react.default.createContext(undefined);
function LicenseProvider({
  children
}) {
  const {
    licensing
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const license = (0, _useObservable.default)(licensing.license$);
  // if license is not loaded yet, consider it valid
  const hasInvalidLicense = (license === null || license === void 0 ? void 0 : license.isActive) === false;

  // if license is invalid show an error message
  if (hasInvalidLicense) {
    return /*#__PURE__*/_react.default.createElement(_invalid_license_notification.InvalidLicenseNotification, null);
  }

  // render rest of application and pass down license via context
  return /*#__PURE__*/_react.default.createElement(LicenseContext.Provider, {
    value: license,
    children: children
  });
}