"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridScrollBarStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridScrollBarStyles = exports.euiDataGridScrollBarStyles = function euiDataGridScrollBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Note that 'borders' *must* be rendered with inset box-shadow, because actual
  // `border` CSS will affect the relative position of the child scroll bar overlays
  // and cause them to be off by the width of the border
  var borderWidth = euiTheme.border.width.thin;
  var borderColor = euiTheme.border.color;
  return {
    euiDataGrid__scrollOverlay: /*#__PURE__*/(0, _react.css)("position:absolute;inset:0;", (0, _global_styling.logicalCSS)('top', "-".concat(borderWidth)), "pointer-events:none;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Ensure the scrolling data grid body always has border edges regardless of cell position
      none: "box-shadow: inset 0 0 0 ".concat(borderWidth, " ").concat(borderColor, ";"),
      // Windows high contrast themes ignore box-shadow, so use a pseudo element workaround
      forced: "\n          &::before {\n            content: '';\n            position: absolute;\n            inset: 0;\n            ".concat((0, _global_styling.logicalCSS)('border-vertical', euiTheme.border.thin), "\n          }\n          &::after {\n            content: '';\n            position: absolute;\n            inset: 0;\n            ").concat((0, _global_styling.logicalCSS)('border-horizontal', euiTheme.border.thin), "\n          }\n        ")
    }), " .euiDataGrid--bordersHorizontal &{", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n            box-shadow: inset 0 -".concat((0, _global_styling.mathWithUnits)(borderWidth, function (x) {
        return x * 2;
      }), " 0 -").concat(borderWidth, " ").concat(borderColor, ";\n          "),
      forced: "\n            &::after {\n              display: none;\n            }\n          "
    }), ";};label:euiDataGrid__scrollOverlay;"),
    // Ensure the horizontal scrollbar has a top border
    euiDataGrid__scrollBarOverlayBottom: /*#__PURE__*/(0, _react.css)("position:absolute;inset-inline:0;", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), ";;label:euiDataGrid__scrollBarOverlayBottom;"),
    // Ensure the vertical scrollbar has a left border
    euiDataGrid__scrollBarOverlayRight: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin), ";;label:euiDataGrid__scrollBarOverlayRight;")
    // Note: Scroll bar border positions are set via JS inline style, since
    // JS has access to the exact OS scrollbar width/height and CSS doesn't
  };
};