"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspIntegrationLink = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _use_cis_kubernetes_integration = require("../api/use_cis_kubernetes_integration");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCspIntegrationLink = policyTemplate => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const cisIntegration = (0, _use_cis_kubernetes_integration.useCisKubernetesIntegration)();
  if (!cisIntegration.isSuccess) return;
  const path = _public.pagePathGetters.add_integration_to_policy({
    integration: policyTemplate,
    pkgkey: (0, _public.pkgKeyFromPackageInfo)({
      name: cisIntegration.data.item.name,
      version: cisIntegration.data.item.version
    })
  }).join('');
  return http.basePath.prepend(path);
};
exports.useCspIntegrationLink = useCspIntegrationLink;