"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  INCIDENT_MANAGEMENT_SYSTEM_TITLE: true,
  INCIDENT_MANAGEMENT_SYSTEM_DESC: true,
  INCIDENT_MANAGEMENT_SYSTEM_LABEL: true,
  ADD_NEW_CONNECTOR: true,
  ADD_CONNECTOR: true,
  CASE_CLOSURE_OPTIONS_TITLE: true,
  CASE_CLOSURE_OPTIONS_DESC: true,
  CASE_CLOSURE_OPTIONS_LABEL: true,
  CASE_CLOSURE_OPTIONS_MANUAL: true,
  CASE_CLOSURE_OPTIONS_NEW_INCIDENT: true,
  FIELD_MAPPING_TITLE: true,
  FIELD_MAPPING_DESC: true,
  FIELD_MAPPING_DESC_ERR: true,
  FIELD_MAPPING_FIRST_COL: true,
  FIELD_MAPPING_SECOND_COL: true,
  FIELD_MAPPING_THIRD_COL: true,
  CANCEL: true,
  SAVE: true,
  WARNING_NO_CONNECTOR_TITLE: true,
  COMMENT: true,
  UPDATE_SELECTED_CONNECTOR: true,
  DEPRECATED_TOOLTIP_TEXT: true,
  DEPRECATED_TOOLTIP_CONTENT: true,
  CONFIGURE_CASES_PAGE_TITLE: true,
  CASES_WEBHOOK_MAPPINGS: true,
  ADD_CUSTOM_FIELD: true,
  EDIT_CUSTOM_FIELD: true,
  CREATE_TEMPLATE: true,
  EDIT_TEMPLATE: true,
  ADD_OBSERVABLE_TYPE: true,
  EDIT_OBSERVABLE_TYPE: true
};
exports.WARNING_NO_CONNECTOR_TITLE = exports.UPDATE_SELECTED_CONNECTOR = exports.SAVE = exports.INCIDENT_MANAGEMENT_SYSTEM_TITLE = exports.INCIDENT_MANAGEMENT_SYSTEM_LABEL = exports.INCIDENT_MANAGEMENT_SYSTEM_DESC = exports.FIELD_MAPPING_TITLE = exports.FIELD_MAPPING_THIRD_COL = exports.FIELD_MAPPING_SECOND_COL = exports.FIELD_MAPPING_FIRST_COL = exports.FIELD_MAPPING_DESC_ERR = exports.FIELD_MAPPING_DESC = exports.EDIT_TEMPLATE = exports.EDIT_OBSERVABLE_TYPE = exports.EDIT_CUSTOM_FIELD = exports.DEPRECATED_TOOLTIP_TEXT = exports.DEPRECATED_TOOLTIP_CONTENT = exports.CREATE_TEMPLATE = exports.CONFIGURE_CASES_PAGE_TITLE = exports.COMMENT = exports.CASE_CLOSURE_OPTIONS_TITLE = exports.CASE_CLOSURE_OPTIONS_NEW_INCIDENT = exports.CASE_CLOSURE_OPTIONS_MANUAL = exports.CASE_CLOSURE_OPTIONS_LABEL = exports.CASE_CLOSURE_OPTIONS_DESC = exports.CASES_WEBHOOK_MAPPINGS = exports.CANCEL = exports.ADD_OBSERVABLE_TYPE = exports.ADD_NEW_CONNECTOR = exports.ADD_CUSTOM_FIELD = exports.ADD_CONNECTOR = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INCIDENT_MANAGEMENT_SYSTEM_TITLE = exports.INCIDENT_MANAGEMENT_SYSTEM_TITLE = _i18n.i18n.translate('xpack.cases.configureCases.incidentManagementSystemTitle', {
  defaultMessage: 'External incident management system'
});
const INCIDENT_MANAGEMENT_SYSTEM_DESC = exports.INCIDENT_MANAGEMENT_SYSTEM_DESC = _i18n.i18n.translate('xpack.cases.configureCases.incidentManagementSystemDesc', {
  defaultMessage: 'Connect your cases to an external incident management system. You can then push case data as an incident in a third-party system.'
});
const INCIDENT_MANAGEMENT_SYSTEM_LABEL = exports.INCIDENT_MANAGEMENT_SYSTEM_LABEL = _i18n.i18n.translate('xpack.cases.configureCases.incidentManagementSystemLabel', {
  defaultMessage: 'Incident management system'
});
const ADD_NEW_CONNECTOR = exports.ADD_NEW_CONNECTOR = _i18n.i18n.translate('xpack.cases.configureCases.addNewConnector', {
  defaultMessage: 'Add new connector'
});
const ADD_CONNECTOR = exports.ADD_CONNECTOR = _i18n.i18n.translate('xpack.cases.configureCases.addConnector', {
  defaultMessage: 'Add connector'
});
const CASE_CLOSURE_OPTIONS_TITLE = exports.CASE_CLOSURE_OPTIONS_TITLE = _i18n.i18n.translate('xpack.cases.configureCases.caseClosureOptionsTitle', {
  defaultMessage: 'Case closures'
});
const CASE_CLOSURE_OPTIONS_DESC = exports.CASE_CLOSURE_OPTIONS_DESC = _i18n.i18n.translate('xpack.cases.configureCases.caseClosureOptionsDesc', {
  defaultMessage: 'Define how to close your cases. Automatic closures require an established connection to an external incident management system.'
});
const CASE_CLOSURE_OPTIONS_LABEL = exports.CASE_CLOSURE_OPTIONS_LABEL = _i18n.i18n.translate('xpack.cases.configureCases.caseClosureOptionsLabel', {
  defaultMessage: 'Case closure options'
});
const CASE_CLOSURE_OPTIONS_MANUAL = exports.CASE_CLOSURE_OPTIONS_MANUAL = _i18n.i18n.translate('xpack.cases.configureCases.caseClosureOptionsManual', {
  defaultMessage: 'Manually close cases'
});
const CASE_CLOSURE_OPTIONS_NEW_INCIDENT = exports.CASE_CLOSURE_OPTIONS_NEW_INCIDENT = _i18n.i18n.translate('xpack.cases.configureCases.caseClosureOptionsNewIncident', {
  defaultMessage: 'Automatically close cases when pushing new incident to external system'
});
const FIELD_MAPPING_TITLE = thirdPartyName => _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingTitle', {
  values: {
    thirdPartyName
  },
  defaultMessage: '{ thirdPartyName } field mappings'
});
exports.FIELD_MAPPING_TITLE = FIELD_MAPPING_TITLE;
const FIELD_MAPPING_DESC = thirdPartyName => _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingDesc', {
  values: {
    thirdPartyName
  },
  defaultMessage: 'Map Case fields to { thirdPartyName } fields when pushing data to { thirdPartyName }. Field mappings require an established connection to { thirdPartyName }.'
});
exports.FIELD_MAPPING_DESC = FIELD_MAPPING_DESC;
const FIELD_MAPPING_DESC_ERR = thirdPartyName => _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingDescErr', {
  values: {
    thirdPartyName
  },
  defaultMessage: 'Failed to retrieve mappings for { thirdPartyName }.'
});
exports.FIELD_MAPPING_DESC_ERR = FIELD_MAPPING_DESC_ERR;
const FIELD_MAPPING_FIRST_COL = exports.FIELD_MAPPING_FIRST_COL = _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingFirstCol', {
  defaultMessage: 'Kibana case field'
});
const FIELD_MAPPING_SECOND_COL = thirdPartyName => _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingSecondCol', {
  values: {
    thirdPartyName
  },
  defaultMessage: '{ thirdPartyName } field'
});
exports.FIELD_MAPPING_SECOND_COL = FIELD_MAPPING_SECOND_COL;
const FIELD_MAPPING_THIRD_COL = exports.FIELD_MAPPING_THIRD_COL = _i18n.i18n.translate('xpack.cases.configureCases.fieldMappingThirdCol', {
  defaultMessage: 'On edit and update'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.cases.configureCases.cancelButton', {
  defaultMessage: 'Cancel'
});
const SAVE = exports.SAVE = _i18n.i18n.translate('xpack.cases.configureCases.saveButton', {
  defaultMessage: 'Save'
});
const WARNING_NO_CONNECTOR_TITLE = exports.WARNING_NO_CONNECTOR_TITLE = _i18n.i18n.translate('xpack.cases.configureCases.warningTitle', {
  defaultMessage: 'Warning'
});
const COMMENT = exports.COMMENT = _i18n.i18n.translate('xpack.cases.configureCases.commentMapping', {
  defaultMessage: 'Comments'
});
const UPDATE_SELECTED_CONNECTOR = connectorName => _i18n.i18n.translate('xpack.cases.configureCases.updateSelectedConnector', {
  values: {
    connectorName
  },
  defaultMessage: 'Update { connectorName }'
});
exports.UPDATE_SELECTED_CONNECTOR = UPDATE_SELECTED_CONNECTOR;
const DEPRECATED_TOOLTIP_TEXT = exports.DEPRECATED_TOOLTIP_TEXT = _i18n.i18n.translate('xpack.cases.configureCases.deprecatedTooltipText', {
  defaultMessage: 'deprecated'
});
const DEPRECATED_TOOLTIP_CONTENT = exports.DEPRECATED_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.cases.configureCases.deprecatedTooltipContent', {
  defaultMessage: 'This connector is deprecated. Update it, or create a new one.'
});
const CONFIGURE_CASES_PAGE_TITLE = exports.CONFIGURE_CASES_PAGE_TITLE = _i18n.i18n.translate('xpack.cases.configureCases.headerTitle', {
  defaultMessage: 'Settings'
});
const CASES_WEBHOOK_MAPPINGS = exports.CASES_WEBHOOK_MAPPINGS = _i18n.i18n.translate('xpack.cases.configureCases.casesWebhookMappings', {
  defaultMessage: 'Webhook - Case Management field mappings are configured in the connector settings in the third-party REST API JSON.'
});
const ADD_CUSTOM_FIELD = exports.ADD_CUSTOM_FIELD = _i18n.i18n.translate('xpack.cases.configureCases.customFields.addCustomField', {
  defaultMessage: 'Add field'
});
const EDIT_CUSTOM_FIELD = exports.EDIT_CUSTOM_FIELD = _i18n.i18n.translate('xpack.cases.configureCases.customFields.editCustomField', {
  defaultMessage: 'Edit field'
});
const CREATE_TEMPLATE = exports.CREATE_TEMPLATE = _i18n.i18n.translate('xpack.cases.configureCases.templates.flyoutTitle', {
  defaultMessage: 'Add template'
});
const EDIT_TEMPLATE = exports.EDIT_TEMPLATE = _i18n.i18n.translate('xpack.cases.configureCases.templates.editTemplate', {
  defaultMessage: 'Edit template'
});
const ADD_OBSERVABLE_TYPE = exports.ADD_OBSERVABLE_TYPE = _i18n.i18n.translate('xpack.cases.configureCases.observableTypes.addObservableType', {
  defaultMessage: 'Add observable type'
});
const EDIT_OBSERVABLE_TYPE = exports.EDIT_OBSERVABLE_TYPE = _i18n.i18n.translate('xpack.cases.configureCases.observableTypes.editObservableType', {
  defaultMessage: 'Edit observable type'
});