"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExternalLinkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _react2 = require("@emotion/react");
var _excluded = ["target", "external"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * DRY util for indicating external links both via icon and to
 * screen readers. Used internally by at EuiLink and EuiListGroupItem
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var iconStyle = function iconStyle(_ref) {
  var euiTheme = _ref.euiTheme;
  return (0, _global_styling.logicalStyle)('margin-left', euiTheme.size.xs);
};
var EuiExternalLinkIcon = exports.EuiExternalLinkIcon = function EuiExternalLinkIcon(_ref2) {
  var target = _ref2.target,
    external = _ref2.external,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var iconCssStyle = (0, _services.useEuiMemoizedStyles)(iconStyle);
  var showExternalLinkIcon = target === '_blank' && external !== false || external === true;
  return (0, _react2.jsx)(_react.default.Fragment, null, showExternalLinkIcon && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_icon.EuiIcon, _extends({
    css: iconCssStyle,
    size: "s",
    type: "popout",
    role: "presentation"
  }, rest)), target === '_blank' ? (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiExternalLinkIcon.newTarget.screenReaderOnlyText",
    default: "(external, opens in a new tab or window)"
  }))) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiExternalLinkIcon.externalTarget.screenReaderOnlyText",
    default: "(external)"
  }))))));
};
EuiExternalLinkIcon.propTypes = {
  target: _propTypes.default.any,
  /**
     * Set to true to show an icon indicating that it is an external link;
     * Defaults to true if `target="_blank"`
     */
  external: _propTypes.default.bool
};