"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImagePreviewModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * By default the image formatter sets the max-width to "none" on the <img /> tag
 * To render nicely the image in the modal we want max_width: 100%
 */
const setMaxWidthImage = imgHTML => {
  const regex = new RegExp('max-width:[^;]+;', 'gm');
  if (regex.test(imgHTML)) {
    return imgHTML.replace(regex, 'max-width: 100%;');
  }
  return imgHTML;
};
const ImagePreviewModal = ({
  imgHTML,
  closeModal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.previewImageModal
    // We  can dangerously set HTML here because this content is guaranteed to have been run through a valid field formatter first.
    ,
    dangerouslySetInnerHTML: {
      __html: setMaxWidthImage(imgHTML)
    } // eslint-disable-line react/no-danger
  })));
};
exports.ImagePreviewModal = ImagePreviewModal;
const styles = {
  previewImageModal: (0, _react2.css)({
    padding: _uiTheme.euiThemeVars.euiSize,
    '& img': {
      maxWidth: '100%'
    }
  })
};