"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallationStats = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _services = require("@kbn/fleet-plugin/server/services");
var _constants = require("../../../../common/constants");
var _helpers = require("../../../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInstallationStats = async (esClient, soClient, coreServices, logger) => {
  const [, cloudDefendServerPluginStartDeps] = await coreServices;
  const cloudDefendContext = {
    logger,
    esClient,
    soClient,
    agentPolicyService: cloudDefendServerPluginStartDeps.fleet.agentPolicyService,
    packagePolicyService: cloudDefendServerPluginStartDeps.fleet.packagePolicyService
  };
  const getInstalledPackagePolicies = async (packagePolicies, agentPolicies) => {
    const installationStats = packagePolicies.map(packagePolicy => {
      var _agentPolicies$find$a, _agentPolicies$find, _input$vars, _input$vars$configura, _packagePolicy$packag;
      const agentCounts = (_agentPolicies$find$a = agentPolicies === null || agentPolicies === void 0 ? void 0 : (_agentPolicies$find = agentPolicies.find(agentPolicy => (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) === packagePolicy.policy_id)) === null || _agentPolicies$find === void 0 ? void 0 : _agentPolicies$find.agents) !== null && _agentPolicies$find$a !== void 0 ? _agentPolicies$find$a : 0;
      const input = (0, _helpers.getInputFromPolicy)(packagePolicy, _constants.INPUT_CONTROL);
      const policyYaml = input === null || input === void 0 ? void 0 : (_input$vars = input.vars) === null || _input$vars === void 0 ? void 0 : (_input$vars$configura = _input$vars.configuration) === null || _input$vars$configura === void 0 ? void 0 : _input$vars$configura.value;
      const {
        selectors,
        responses
      } = (0, _helpers.getSelectorsAndResponsesFromYaml)(policyYaml);
      return {
        package_policy_id: packagePolicy.id,
        package_version: (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.version,
        created_at: packagePolicy.created_at,
        agent_policy_id: packagePolicy.policy_ids[0],
        agent_count: agentCounts,
        policy_yaml: policyYaml,
        selectors,
        responses
      };
    });
    return installationStats;
  };
  const packagePolicies = await cloudDefendContext.packagePolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:"${_constants.INTEGRATION_PACKAGE_NAME}"`
  });
  const agentPolicies = await _services.agentPolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: '',
    esClient,
    withAgentCount: true
  });
  if (!packagePolicies) return [];
  const installationStats = await getInstalledPackagePolicies(packagePolicies.items, (agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.items) || []);
  return installationStats;
};
exports.getInstallationStats = getInstallationStats;