"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PoliciesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _timestamp_table_cell = require("../timestamp_table_cell");
var _use_kibana = require("../../common/hooks/use_kibana");
var TEST_SUBJ = _interopRequireWildcard(require("../../pages/policies/test_subjects"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyButtonLink = ({
  name,
  id: policyId
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const [fleetBase, path] = _public.pagePathGetters.policy_details({
    policyId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend([fleetBase, path].join(''))
  }, name);
};
const IntegrationButtonLink = ({
  packageName,
  policyId,
  packagePolicyId
}) => {
  const editIntegrationLink = _public.pagePathGetters.edit_integration({
    packagePolicyId,
    policyId
  }).join('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: editIntegrationLink
  }, packageName);
};
const POLICIES_TABLE_COLUMNS = [{
  field: 'package_policy.name',
  name: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesTable.integrationNameColumnTitle', {
    defaultMessage: 'Integration Name'
  }),
  render: (packageName, policy) => /*#__PURE__*/_react.default.createElement(IntegrationButtonLink, {
    packageName: packageName,
    packagePolicyId: policy.package_policy.id,
    policyId: policy.package_policy.policy_ids[0]
  }),
  truncateText: true,
  sortable: true,
  'data-test-subj': TEST_SUBJ.POLICIES_TABLE_COLUMNS.INTEGRATION_NAME
}, {
  field: 'agent_policy.name',
  name: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesTable.agentPolicyColumnTitle', {
    defaultMessage: 'Agent Policy'
  }),
  render: (name, policy) => /*#__PURE__*/_react.default.createElement(AgentPolicyButtonLink, {
    name: name,
    id: policy.agent_policy.id
  }),
  truncateText: true,
  'data-test-subj': TEST_SUBJ.POLICIES_TABLE_COLUMNS.AGENT_POLICY
}, {
  field: 'agent_policy.agents',
  name: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesTable.numberOfAgentsColumnTitle', {
    defaultMessage: 'Number of Agents'
  }),
  truncateText: true,
  'data-test-subj': TEST_SUBJ.POLICIES_TABLE_COLUMNS.NUMBER_OF_AGENTS
}, {
  field: 'package_policy.created_by',
  name: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesTable.createdByColumnTitle', {
    defaultMessage: 'Created by'
  }),
  dataType: 'string',
  truncateText: true,
  sortable: true,
  'data-test-subj': TEST_SUBJ.POLICIES_TABLE_COLUMNS.CREATED_BY
}, {
  field: 'package_policy.created_at',
  name: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesTable.createdAtColumnTitle', {
    defaultMessage: 'Created at'
  }),
  dataType: 'date',
  truncateText: true,
  render: timestamp => /*#__PURE__*/_react.default.createElement(_timestamp_table_cell.TimestampTableCell, {
    timestamp: timestamp
  }),
  sortable: true,
  'data-test-subj': TEST_SUBJ.POLICIES_TABLE_COLUMNS.CREATED_AT
}];
const PoliciesTable = ({
  policies,
  pageIndex,
  pageSize,
  totalItemCount,
  loading,
  error,
  setQuery,
  noItemsMessage,
  sorting,
  ...rest
}) => {
  const pagination = {
    pageIndex: Math.max(pageIndex - 1, 0),
    pageSize,
    totalItemCount
  };
  const onChange = ({
    page,
    sort
  }) => {
    setQuery({
      page: {
        ...page,
        index: page.index + 1
      },
      sort
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": rest['data-test-subj'],
    items: policies,
    columns: POLICIES_TABLE_COLUMNS,
    itemId: item => [item.agent_policy.id, item.package_policy.id].join('/'),
    pagination: pagination,
    onChange: onChange,
    tableLayout: "fixed",
    loading: loading,
    noItemsMessage: noItemsMessage,
    error: error,
    sorting: sorting
  });
};
exports.PoliciesTable = PoliciesTable;