"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    border,
    size
  } = euiTheme;
  const accordionColor = (0, _eui.useEuiBackgroundColor)('subdued');
  return (0, _react.useMemo)(() => {
    const options = {
      position: 'absolute',
      top: size.m,
      right: size.m
    };
    const accordion = {
      borderRadius: border.radius.medium,
      '> .euiAccordion__triggerWrapper': {
        padding: size.m
      },
      backgroundColor: accordionColor
    };
    const accordionHeader = {
      '> *': {
        display: 'inline-block',
        verticalAlign: 'middle'
      },
      '> b': {
        marginRight: size.s
      }
    };
    return {
      options,
      accordion,
      accordionHeader
    };
  }, [accordionColor, border.radius.medium, size.m, size.s]);
};
exports.useStyles = useStyles;