"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDetailRoute = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _comparison_rt = require("../../../../common/comparison_rt");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _environment_rt = require("../../../../common/environment_rt");
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
var _time_range_metadata_context = require("../../../context/time_range_metadata/time_range_metadata_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _alerts_overview = require("../../app/alerts_overview");
var _use_tabs = require("../../app/infra_overview/infra_tabs/use_tabs");
var _apm_service_template = require("../templates/apm_service_template");
var _apm_service_wrapper = require("./apm_service_wrapper");
var _redirect_to_default_service_route_view = require("./redirect_to_default_service_route_view");
var _service_dependencies = require("../../app/service_dependencies");
var _service_dashboards = require("../../app/service_dashboards");
var _error_group_details = require("../../app/error_group_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorGroupOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/error_group_overview'))).then(mod => ({
  default: mod.ErrorGroupOverview
})));
const InfraOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/infra_overview'))).then(mod => ({
  default: mod.InfraOverview
})));
const Metrics = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/metrics'))).then(mod => ({
  default: mod.Metrics
})));
const MetricsDetails = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/metrics_details'))).then(mod => ({
  default: mod.MetricsDetails
})));
const ServiceLogs = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/service_logs'))).then(mod => ({
  default: mod.ServiceLogs
})));
const ServiceMapServiceDetail = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/service_map'))).then(mod => ({
  default: mod.ServiceMapServiceDetail
})));
const ServiceOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/service_overview'))).then(mod => ({
  default: mod.ServiceOverview
})));
const TransactionDetails = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/transaction_details'))).then(mod => ({
  default: mod.TransactionDetails
})));
const TransactionOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/transaction_overview'))).then(mod => ({
  default: mod.TransactionOverview
})));
const ProfilingOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/profiling_overview'))).then(mod => ({
  default: mod.ProfilingOverview
})));
function page({
  title,
  tab,
  element,
  searchBarOptions
}) {
  return {
    element: /*#__PURE__*/_react.default.createElement(_apm_service_template.ApmServiceTemplate, {
      title: title,
      selectedTab: tab,
      searchBarOptions: searchBarOptions
    }, element)
  };
}
function RedirectNodesToMetrics() {
  const {
    query,
    path
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/nodes');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/services/${path.serviceName}/metrics`,
      search
    }
  });
}
function RedirectNodeMetricsToMetricsDetails() {
  const {
    query,
    path
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/nodes/{serviceNodeName}/metrics');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/services/${path.serviceName}/metrics/${path.serviceNodeName}`,
      search
    }
  });
}
const serviceDetailRoute = exports.serviceDetailRoute = {
  '/services/{serviceName}': {
    element: /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.ApmTimeRangeMetadataContextProvider, null, /*#__PURE__*/_react.default.createElement(_apm_service_wrapper.ApmServiceWrapper, null)),
    params: t.intersection([t.type({
      path: t.type({
        serviceName: t.string
      })
    }), t.type({
      query: t.intersection([_environment_rt.environmentRt, t.type({
        rangeFrom: t.string,
        rangeTo: t.string,
        kuery: t.string,
        serviceGroup: t.string,
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), t.partial({
        latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt,
        transactionType: t.string,
        refreshPaused: t.union([t.literal('true'), t.literal('false')]),
        refreshInterval: t.string
      }), _comparison_rt.offsetRt])
    })]),
    defaults: {
      query: {
        kuery: '',
        environment: _environment_filter_values.ENVIRONMENT_ALL.value,
        serviceGroup: '',
        latencyAggregationType: _latency_aggregation_types.LatencyAggregationType.avg
      }
    },
    children: {
      '/services/{serviceName}/overview': {
        ...page({
          element: /*#__PURE__*/_react.default.createElement(ServiceOverview, null),
          tab: 'overview',
          title: _i18n.i18n.translate('xpack.apm.views.overview.title', {
            defaultMessage: 'Overview'
          }),
          searchBarOptions: {
            hidden: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')])
          })
        })
      },
      '/services/{serviceName}/transactions': {
        ...page({
          tab: 'transactions',
          title: _i18n.i18n.translate('xpack.apm.views.transactions.title', {
            defaultMessage: 'Transactions'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
          searchBarOptions: {
            showTransactionTypeSelector: true,
            showTimeComparison: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')])
          })
        }),
        children: {
          '/services/{serviceName}/transactions/view': {
            element: /*#__PURE__*/_react.default.createElement(TransactionDetails, null),
            params: t.type({
              query: t.intersection([t.type({
                transactionName: t.string,
                comparisonEnabled: _ioTsUtils.toBooleanRt,
                showCriticalPath: _ioTsUtils.toBooleanRt
              }), t.partial({
                traceId: t.string,
                transactionId: t.string,
                flyoutDetailTab: t.string
              }), _comparison_rt.offsetRt])
            }),
            defaults: {
              query: {
                showCriticalPath: ''
              }
            }
          },
          '/services/{serviceName}/transactions': {
            element: /*#__PURE__*/_react.default.createElement(TransactionOverview, null)
          }
        }
      },
      '/services/{serviceName}/dependencies': page({
        element: /*#__PURE__*/_react.default.createElement(_service_dependencies.ServiceDependencies, null),
        tab: 'dependencies',
        title: _i18n.i18n.translate('xpack.apm.views.dependencies.title', {
          defaultMessage: 'Dependencies'
        }),
        searchBarOptions: {
          showTimeComparison: true
        }
      }),
      '/services/{serviceName}/errors': {
        ...page({
          tab: 'errors',
          title: _i18n.i18n.translate('xpack.apm.views.errors.title', {
            defaultMessage: 'Errors'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
          searchBarOptions: {
            showTimeComparison: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')])
          })
        }),
        children: {
          '/services/{serviceName}/errors/{groupId}': {
            element: /*#__PURE__*/_react.default.createElement(_error_group_details.ErrorGroupDetails, null),
            params: t.type({
              path: t.type({
                groupId: t.string
              }),
              query: t.partial({
                errorId: t.string
              })
            })
          },
          '/services/{serviceName}/errors': {
            element: /*#__PURE__*/_react.default.createElement(ErrorGroupOverview, null)
          }
        }
      },
      '/services/{serviceName}/metrics': {
        ...page({
          tab: 'metrics',
          title: _i18n.i18n.translate('xpack.apm.views.metrics.title', {
            defaultMessage: 'Metrics'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)
        }),
        children: {
          '/services/{serviceName}/metrics': {
            element: /*#__PURE__*/_react.default.createElement(Metrics, null)
          },
          '/services/{serviceName}/metrics/{id}': {
            element: /*#__PURE__*/_react.default.createElement(MetricsDetails, null),
            params: t.type({
              path: t.type({
                id: t.string
              })
            })
          }
        }
      },
      // Deprecated: redirect it to metrics
      '/services/{serviceName}/nodes': {
        ...page({
          tab: 'nodes',
          title: _i18n.i18n.translate('xpack.apm.views.nodes.title', {
            defaultMessage: 'Metrics'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)
        }),
        children: {
          '/services/{serviceName}/nodes/{serviceNodeName}/metrics': {
            element: /*#__PURE__*/_react.default.createElement(RedirectNodeMetricsToMetricsDetails, null),
            params: t.type({
              path: t.type({
                serviceNodeName: t.string
              })
            })
          },
          '/services/{serviceName}/nodes': {
            element: /*#__PURE__*/_react.default.createElement(RedirectNodesToMetrics, null),
            params: t.partial({
              query: t.partial({
                sortDirection: t.string,
                sortField: t.string,
                pageSize: t.string,
                page: t.string
              })
            })
          }
        }
      },
      '/services/{serviceName}/service-map': page({
        tab: 'service-map',
        title: _i18n.i18n.translate('xpack.apm.views.serviceMap.title', {
          defaultMessage: 'Service Map'
        }),
        element: /*#__PURE__*/_react.default.createElement(ServiceMapServiceDetail, null),
        searchBarOptions: {
          hidden: true
        }
      }),
      '/services/{serviceName}/logs': page({
        tab: 'logs',
        title: _i18n.i18n.translate('xpack.apm.views.logs.title', {
          defaultMessage: 'Logs'
        }),
        element: /*#__PURE__*/_react.default.createElement(ServiceLogs, null),
        searchBarOptions: {
          showQueryInput: false
        }
      }),
      '/services/{serviceName}/infrastructure': {
        ...page({
          tab: 'infrastructure',
          title: _i18n.i18n.translate('xpack.apm.views.infra.title', {
            defaultMessage: 'Infrastructure'
          }),
          element: /*#__PURE__*/_react.default.createElement(InfraOverview, null),
          searchBarOptions: {
            showUnifiedSearchBar: false
          }
        }),
        params: t.partial({
          query: t.partial({
            detailTab: t.union([t.literal(_use_tabs.InfraTab.containers), t.literal(_use_tabs.InfraTab.pods), t.literal(_use_tabs.InfraTab.hosts)])
          })
        })
      },
      '/services/{serviceName}/alerts': {
        ...page({
          tab: 'alerts',
          title: _i18n.i18n.translate('xpack.apm.views.alerts.title', {
            defaultMessage: 'Alerts'
          }),
          element: /*#__PURE__*/_react.default.createElement(_alerts_overview.AlertsOverview, null),
          searchBarOptions: {
            hidden: true
          }
        }),
        params: t.partial({
          query: t.partial({
            alertStatus: t.union([t.literal(_ruleDataUtils.ALERT_STATUS_ACTIVE), t.literal(_ruleDataUtils.ALERT_STATUS_RECOVERED), t.literal(_alerts_overview.ALERT_STATUS_ALL)])
          })
        })
      },
      '/services/{serviceName}/profiling': {
        ...page({
          tab: 'profiling',
          title: _i18n.i18n.translate('xpack.apm.views.profiling.title', {
            defaultMessage: 'Universal Profiling'
          }),
          element: /*#__PURE__*/_react.default.createElement(ProfilingOverview, null),
          searchBarOptions: {
            hidden: true
          }
        })
      },
      '/services/{serviceName}/dashboards': {
        ...page({
          tab: 'dashboards',
          title: _i18n.i18n.translate('xpack.apm.views.dashboard.title', {
            defaultMessage: 'Dashboards'
          }),
          element: /*#__PURE__*/_react.default.createElement(_service_dashboards.ServiceDashboards, null)
        }),
        params: t.partial({
          query: t.partial({
            dashboardId: t.string
          })
        })
      },
      '/services/{serviceName}/': {
        element: /*#__PURE__*/_react.default.createElement(_redirect_to_default_service_route_view.RedirectToDefaultServiceRouteView, null)
      }
    }
  }
};