"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowSolutionSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _coreApplicationCommon = require("@kbn/core-application-common");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RADIO_OPTIONS = [{
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id,
  label: i18n.CREATE_FORM_SOLUTION_OBSERVABILITY_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id}`
}, {
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
  label: i18n.CREATE_FORM_SOLUTION_SECURITY_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id}`
}, {
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management.id,
  label: i18n.CREATE_FORM_SOLUTION_STACK_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.management.id}`
}].sort((a, b) => a.id.localeCompare(b.id));
const MaintenanceWindowSolutionSelection = props => {
  const {
    selectedSolution,
    availableSolutions,
    errors = [],
    isLoading = false,
    isScopedQueryEnabled = false,
    onChange
  } = props;
  const options = (0, _react.useMemo)(() => {
    return RADIO_OPTIONS.map(option => ({
      ...option,
      disabled: !availableSolutions.includes(option.id)
    })).sort((a, b) => a.id.localeCompare(b.id));
  }, [availableSolutions]);
  const onRadioChange = (0, _react.useCallback)(id => {
    onChange(id);
  }, [onChange]);
  const solutionSelection = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      "data-test-subj": "maintenanceWindowSolutionSelectionRadioGroup",
      options: options,
      idSelected: selectedSolution,
      onChange: onRadioChange
    });
  }, [options, selectedSolution, onRadioChange]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": "maintenanceWindowSolutionSelectionLoading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    })));
  }
  return isScopedQueryEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "maintenanceWindowSolutionSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CREATE_FORM_SOLUTION_SELECTION_TITLE), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.CREATE_FORM_SOLUTION_SELECTION_DESCRIPTION)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.CREATE_FORM_SOLUTION_SELECTION_CHECKBOX_GROUP_TITLE,
    isInvalid: !!errors.length,
    error: errors[0]
  }, solutionSelection)));
};
exports.MaintenanceWindowSolutionSelection = MaintenanceWindowSolutionSelection;