/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rank.feature.RankFeatureShardPhase;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;

public class MockSearchService
extends SearchService {
    private static final Map<ReaderContext, Throwable> ACTIVE_SEARCH_CONTEXTS = new ConcurrentHashMap<ReaderContext, Throwable>();
    private Consumer<ReaderContext> onPutContext = context -> {};
    private Consumer<ReaderContext> onRemoveContext = context -> {};
    private Consumer<SearchContext> onCreateSearchContext = context -> {};
    private Function<CancellableTask, CancellableTask> onCheckCancelled = Function.identity();

    public static void assertNoInFlightContext() {
        HashMap<ReaderContext, Throwable> copy = new HashMap<ReaderContext, Throwable>(ACTIVE_SEARCH_CONTEXTS);
        if (!copy.isEmpty()) {
            throw new AssertionError("There are still [" + copy.size() + "] in-flight contexts. The first one's creation site is listed as the cause of this exception.", (Throwable)copy.values().iterator().next());
        }
    }

    static void addActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.put(context, new RuntimeException(context.toString()));
    }

    static void removeActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.remove(context);
    }

    public MockSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, RankFeatureShardPhase rankFeatureShardPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer) {
        super(clusterService, indicesService, threadPool, scriptService, bigArrays, rankFeatureShardPhase, fetchPhase, responseCollectorService, circuitBreakerService, executorSelector, tracer);
    }

    protected void putReaderContext(ReaderContext context) {
        this.onPutContext.accept(context);
        MockSearchService.addActiveContext(context);
        super.putReaderContext(context);
    }

    protected ReaderContext removeReaderContext(long id) {
        ReaderContext removed = super.removeReaderContext(id);
        if (removed != null) {
            this.onRemoveContext.accept(removed);
            MockSearchService.removeActiveContext(removed);
        }
        return removed;
    }

    public void setOnPutContext(Consumer<ReaderContext> onPutContext) {
        this.onPutContext = onPutContext;
    }

    public void setOnRemoveContext(Consumer<ReaderContext> onRemoveContext) {
        this.onRemoveContext = onRemoveContext;
    }

    public void setOnCreateSearchContext(Consumer<SearchContext> onCreateSearchContext) {
        this.onCreateSearchContext = onCreateSearchContext;
    }

    protected SearchContext createContext(ReaderContext readerContext, ShardSearchRequest request, CancellableTask task, SearchService.ResultsType resultsType, boolean includeAggregations) throws IOException {
        SearchContext searchContext = super.createContext(readerContext, request, task, resultsType, includeAggregations);
        try {
            this.onCreateSearchContext.accept(searchContext);
        }
        catch (Exception e) {
            searchContext.close();
            throw e;
        }
        return searchContext;
    }

    public SearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        SearchContext searchContext = super.createSearchContext(request, timeout);
        this.onPutContext.accept(searchContext.readerContext());
        searchContext.addReleasable(() -> this.onRemoveContext.accept(searchContext.readerContext()));
        return searchContext;
    }

    public void setOnCheckCancelled(Function<CancellableTask, CancellableTask> onCheckCancelled) {
        this.onCheckCancelled = onCheckCancelled;
    }

    protected void checkCancelled(CancellableTask task) {
        super.checkCancelled(this.onCheckCancelled.apply(task));
    }

    public static class TestPlugin
    extends Plugin {
    }
}

