/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;

public abstract class LicenseSettings {
    public static final Setting<License.LicenseType> SELF_GENERATED_LICENSE_TYPE = new Setting("xpack.license.self_generated.type", License.LicenseType.BASIC.getTypeName(), s -> {
        License.LicenseType type = License.LicenseType.parse(s);
        return SelfGeneratedLicense.validateSelfGeneratedType(type);
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final List<License.LicenseType> ALLOWABLE_UPLOAD_TYPES = LicenseSettings.getAllowableUploadTypes();
    public static final Setting<List<License.LicenseType>> ALLOWED_LICENSE_TYPES_SETTING = Setting.listSetting((String)"xpack.license.upload.types", ALLOWABLE_UPLOAD_TYPES.stream().map(License.LicenseType::getTypeName).toList(), License.LicenseType::parse, LicenseSettings::validateUploadTypesSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final TimeValue NON_BASIC_SELF_GENERATED_LICENSE_DURATION = TimeValue.timeValueHours((long)720L);
    static final Set<License.LicenseType> VALID_TRIAL_TYPES = Set.of(License.LicenseType.GOLD, License.LicenseType.PLATINUM, License.LicenseType.ENTERPRISE, License.LicenseType.TRIAL);
    static final TimeValue LICENSE_EXPIRATION_WARNING_PERIOD = TimeValue.timeValueDays((long)7L);
    static final long BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS = XPackInfoResponse.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS;
    static final int SELF_GENERATED_LICENSE_MAX_NODES = 1000;
    static final int SELF_GENERATED_LICENSE_MAX_RESOURCE_UNITS = 1000;

    private static List<License.LicenseType> getAllowableUploadTypes() {
        return Stream.of(License.LicenseType.values()).filter(t -> t != License.LicenseType.BASIC).toList();
    }

    private static void validateUploadTypesSetting(List<License.LicenseType> value) {
        if (!ALLOWABLE_UPLOAD_TYPES.containsAll(value)) {
            throw new IllegalArgumentException("Invalid value [" + value.stream().map(License.LicenseType::getTypeName).collect(Collectors.joining(",")) + "] for " + ALLOWED_LICENSE_TYPES_SETTING.getKey() + ", allowed values are [" + ALLOWABLE_UPLOAD_TYPES.stream().map(License.LicenseType::getTypeName).collect(Collectors.joining(",")) + "]");
        }
    }
}

