/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.jdbc.JdbcColumnInfo;
import org.elasticsearch.xpack.sql.jdbc.JdbcResultSet;
import org.elasticsearch.xpack.sql.jdbc.JdbcWrapper;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;

class JdbcResultSetMetaData
implements ResultSetMetaData,
JdbcWrapper {
    private final JdbcResultSet rs;
    private final List<JdbcColumnInfo> columns;

    JdbcResultSetMetaData(JdbcResultSet rs, List<JdbcColumnInfo> columns) {
        this.rs = rs;
        this.columns = columns;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.checkOpen();
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.column(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.column(column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.column(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.column(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.column(column);
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return TypeUtils.isSigned(this.column((int)column).type);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.column(column).displaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        JdbcColumnInfo info = this.column(column);
        return "".equals(info.label) ? info.name : info.label;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.column((int)column).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.column((int)column).schema;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.column(column);
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.column(column).displaySize();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.column((int)column).table;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.column((int)column).catalog;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.column((int)column).type.getVendorTypeNumber();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.column((int)column).type.getName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.column(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.column(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.column(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return TypeUtils.classOf(this.column((int)column).type).getName();
    }

    private void checkOpen() throws SQLException {
        if (this.rs != null) {
            this.rs.checkOpen();
        }
    }

    private JdbcColumnInfo column(int column) throws SQLException {
        this.checkOpen();
        if (column < 1 || column > this.columns.size()) {
            throw new SQLException("Invalid column index [" + column + "]");
        }
        return this.columns.get(column - 1);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.columns);
    }
}

