/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoCentroid;
import org.elasticsearch.search.aggregations.metrics.InternalCentroid;
import org.elasticsearch.search.aggregations.support.SamplingContext;

public class InternalGeoCentroid
extends InternalCentroid
implements GeoCentroid {
    public InternalGeoCentroid(String name, SpatialPoint centroid, long count, Map<String, Object> metadata) {
        super(name, centroid, count, metadata);
    }

    public InternalGeoCentroid(StreamInput in) throws IOException {
        super(in);
    }

    public static InternalGeoCentroid empty(String name, Map<String, Object> metadata) {
        return new InternalGeoCentroid(name, null, 0L, metadata);
    }

    @Override
    protected GeoPoint centroidFromStream(StreamInput in) throws IOException {
        return new GeoPoint(in.readDouble(), in.readDouble());
    }

    @Override
    protected void centroidToStream(StreamOutput out) throws IOException {
        out.writeDouble(this.centroid.getY());
        out.writeDouble(this.centroid.getX());
    }

    @Override
    public String getWriteableName() {
        return "geo_centroid";
    }

    @Override
    protected double extractDouble(String name) {
        return switch (name) {
            case "lat" -> this.centroid.getY();
            case "lon" -> this.centroid.getX();
            default -> throw new IllegalArgumentException("Found unknown path element [" + name + "] in [" + this.getName() + "]");
        };
    }

    @Override
    protected InternalGeoCentroid copyWith(SpatialPoint result, long count) {
        return new InternalGeoCentroid(this.name, result, count, this.getMetadata());
    }

    @Override
    protected InternalGeoCentroid copyWith(double firstSum, double secondSum, long totalCount) {
        GeoPoint result = Double.isNaN(firstSum) ? null : new GeoPoint(firstSum / (double)totalCount, secondSum / (double)totalCount);
        return this.copyWith(result, totalCount);
    }

    @Override
    protected String nameFirst() {
        return "lat";
    }

    @Override
    protected double extractFirst(SpatialPoint point) {
        return point.getY();
    }

    @Override
    protected String nameSecond() {
        return "lon";
    }

    @Override
    protected double extractSecond(SpatialPoint point) {
        return point.getX();
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalGeoCentroid(this.name, this.centroid, samplingContext.scaleUp(this.count), this.getMetadata());
    }
}

