/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.Sample;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class PushDownAndCombineSample
extends OptimizerRules.ParameterizedOptimizerRule<Sample, LogicalOptimizerContext> {
    public PushDownAndCombineSample() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(Sample sample, LogicalOptimizerContext context) {
        UnaryPlan plan = sample;
        LogicalPlan child = sample.child();
        if (child instanceof Sample) {
            Sample sampleChild = (Sample)child;
            Expression probability = PushDownAndCombineSample.combinedProbability(context, sample, sampleChild);
            plan = new Sample(sample.source(), probability, sampleChild.child());
        } else if (child instanceof Enrich || child instanceof Eval || child instanceof Filter || child instanceof OrderBy || child instanceof Project || child instanceof RegexExtract) {
            UnaryPlan unaryChild = (UnaryPlan)child;
            plan = unaryChild.replaceChild(sample.replaceChild(unaryChild.child()));
        }
        return plan;
    }

    private static Expression combinedProbability(LogicalOptimizerContext context, Sample parent, Sample child) {
        double parentProbability = (Double)Foldables.valueOf((FoldContext)context.foldCtx(), (Expression)parent.probability());
        double childProbability = (Double)Foldables.valueOf((FoldContext)context.foldCtx(), (Expression)child.probability());
        return Literal.of((Expression)parent.probability(), (Object)(parentProbability * childProbability));
    }
}

