/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;

abstract class AbstractField
implements ExtractedField {
    private final String name;
    private final Set<String> types;

    AbstractField(String name, Set<String> types) {
        this.name = Objects.requireNonNull(name);
        this.types = Objects.requireNonNull(types);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSearchField() {
        return this.name;
    }

    @Override
    public Set<String> getTypes() {
        return this.types;
    }

    protected Object[] getFieldValue(SearchHit hit) {
        DocumentField keyValue = hit.field(this.getSearchField());
        if (keyValue != null) {
            List values = keyValue.getValues();
            return values.toArray(new Object[0]);
        }
        return new Object[0];
    }
}

