/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.io.IOException;
import org.elasticsearch.common.ssl.DerParser;

public class RdnFieldExtractor {
    public static String extract(byte[] encoded, String oid) {
        try {
            return RdnFieldExtractor.doExtract(encoded, oid);
        }
        catch (IOException | IllegalStateException e) {
            return null;
        }
    }

    private static String doExtract(byte[] encoded, String oid) throws IOException {
        DerParser parser = new DerParser(encoded);
        DerParser.Asn1Object dnSequence = parser.readAsn1Object(16);
        DerParser sequenceParser = dnSequence.getParser();
        String value = null;
        try {
            while (true) {
                DerParser.Asn1Object rdnSet = sequenceParser.readAsn1Object(17);
                DerParser setParser = rdnSet.getParser();
                try {
                    while (true) {
                        DerParser.Asn1Object attrSeq = setParser.readAsn1Object(16);
                        DerParser attrParser = attrSeq.getParser();
                        String attrOid = attrParser.readAsn1Object().getOid();
                        DerParser.Asn1Object attrValue = attrParser.readAsn1Object();
                        if (!oid.equals(attrOid)) continue;
                        value = attrValue.getString();
                    }
                }
                catch (IOException e) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            return value;
        }
    }
}

