/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules.retriever;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;

public class PinnedRankDoc
extends RankDoc {
    public static final String NAME = "pinned_rank_doc";
    private static final TransportVersion PINNED_RETRIEVER = TransportVersion.fromName((String)"pinned_retriever");
    private final boolean isPinned;

    public PinnedRankDoc(int docId, float score, int shardIndex, boolean isPinned) {
        super(docId, score, shardIndex);
        this.isPinned = isPinned;
    }

    public PinnedRankDoc(StreamInput in) throws IOException {
        super(in);
        this.isPinned = in.readBoolean();
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        if (this.isPinned) {
            return Explanation.match((Number)Float.valueOf(this.score), (String)"Pinned document, original explanation:", (Explanation[])sources);
        }
        return super.explain(sources, queryNames);
    }

    public String toString() {
        return super.toString() + ", isPinned=" + this.isPinned;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPinned);
    }

    protected boolean doEquals(RankDoc rd) {
        if (rd instanceof PinnedRankDoc) {
            PinnedRankDoc other = (PinnedRankDoc)rd;
            return this.isPinned == other.isPinned;
        }
        return false;
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.isPinned);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return PINNED_RETRIEVER;
    }
}

