/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.CartesianShapeDVAtomicShapeFieldData;

public class CartesianShapeIndexFieldData
extends AbstractShapeIndexFieldData<CartesianShapeValues> {
    public CartesianShapeIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<CartesianShapeValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, toScriptFieldFactory);
    }

    public LeafShapeFieldData<CartesianShapeValues> load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
        if (info != null) {
            CartesianShapeIndexFieldData.checkCompatible(info, "shape");
        }
        return new CartesianShapeDVAtomicShapeFieldData(reader, this.fieldName, (ToScriptFieldFactory<CartesianShapeValues>)this.toScriptFieldFactory);
    }

    @Override
    protected IllegalArgumentException sortException() {
        return new IllegalArgumentException("can't sort on shape field without using specific sorting feature, like cartesian_distance");
    }
}

