/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.solutions.backuprestore.restorepoints.search;

import com.microsoft.graph.models.ArtifactQuery;
import com.microsoft.graph.models.RestorePointPreference;
import com.microsoft.graph.models.RestorePointTags;
import com.microsoft.graph.models.TimePeriod;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SearchPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchPostRequestBody();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public ArtifactQuery getArtifactQuery() {
        return (ArtifactQuery)this.backingStore.get("artifactQuery");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("artifactQuery", n -> this.setArtifactQuery((ArtifactQuery)n.getObjectValue(ArtifactQuery::createFromDiscriminatorValue)));
        deserializerMap.put("protectionTimePeriod", n -> this.setProtectionTimePeriod((TimePeriod)n.getObjectValue(TimePeriod::createFromDiscriminatorValue)));
        deserializerMap.put("protectionUnitIds", n -> this.setProtectionUnitIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("restorePointPreference", n -> this.setRestorePointPreference((RestorePointPreference)n.getEnumValue(RestorePointPreference::forValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getEnumSetValue(RestorePointTags::forValue)));
        return deserializerMap;
    }

    @Nullable
    public TimePeriod getProtectionTimePeriod() {
        return (TimePeriod)this.backingStore.get("protectionTimePeriod");
    }

    @Nullable
    public List<String> getProtectionUnitIds() {
        return (List)this.backingStore.get("protectionUnitIds");
    }

    @Nullable
    public RestorePointPreference getRestorePointPreference() {
        return (RestorePointPreference)((Object)this.backingStore.get("restorePointPreference"));
    }

    @Nullable
    public EnumSet<RestorePointTags> getTags() {
        return (EnumSet)this.backingStore.get("tags");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("artifactQuery", (Parsable)this.getArtifactQuery(), new Parsable[0]);
        writer.writeObjectValue("protectionTimePeriod", (Parsable)this.getProtectionTimePeriod(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("protectionUnitIds", this.getProtectionUnitIds());
        writer.writeEnumValue("restorePointPreference", (Enum)this.getRestorePointPreference());
        writer.writeEnumSetValue("tags", this.getTags());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setArtifactQuery(@Nullable ArtifactQuery value) {
        this.backingStore.set("artifactQuery", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setProtectionTimePeriod(@Nullable TimePeriod value) {
        this.backingStore.set("protectionTimePeriod", (Object)value);
    }

    public void setProtectionUnitIds(@Nullable List<String> value) {
        this.backingStore.set("protectionUnitIds", value);
    }

    public void setRestorePointPreference(@Nullable RestorePointPreference value) {
        this.backingStore.set("restorePointPreference", (Object)value);
    }

    public void setTags(@Nullable EnumSet<RestorePointTags> value) {
        this.backingStore.set("tags", value);
    }
}

