/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.solutions.backuprestore.enable;

import com.microsoft.graph.models.ServiceStatus;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.solutions.backuprestore.enable.EnablePostRequestBody;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EnableRequestBuilder
extends BaseRequestBuilder {
    public EnableRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/solutions/backupRestore/enable", pathParameters);
    }

    public EnableRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/solutions/backupRestore/enable", rawUrl);
    }

    @Nullable
    public ServiceStatus post(@Nonnull EnablePostRequestBody body) {
        return this.post(body, null);
    }

    @Nullable
    public ServiceStatus post(@Nonnull EnablePostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (ServiceStatus)this.requestAdapter.send(requestInfo, errorMapping, ServiceStatus::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull EnablePostRequestBody body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull EnablePostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public EnableRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new EnableRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

