/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.threatintelligence;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.models.security.ThreatIntelligence;
import com.microsoft.graph.security.threatintelligence.articleindicators.ArticleIndicatorsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.articles.ArticlesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hostcomponents.HostComponentsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hostcookies.HostCookiesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hostpairs.HostPairsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hostports.HostPortsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.HostsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hostsslcertificates.HostSslCertificatesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosttrackers.HostTrackersRequestBuilder;
import com.microsoft.graph.security.threatintelligence.intelligenceprofileindicators.IntelligenceProfileIndicatorsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.intelprofiles.IntelProfilesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.passivednsrecords.PassiveDnsRecordsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.sslcertificates.SslCertificatesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.subdomains.SubdomainsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.vulnerabilities.VulnerabilitiesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.whoishistoryrecords.WhoisHistoryRecordsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.whoisrecords.WhoisRecordsRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ThreatIntelligenceRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ArticleIndicatorsRequestBuilder articleIndicators() {
        return new ArticleIndicatorsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ArticlesRequestBuilder articles() {
        return new ArticlesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostComponentsRequestBuilder hostComponents() {
        return new HostComponentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostCookiesRequestBuilder hostCookies() {
        return new HostCookiesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostPairsRequestBuilder hostPairs() {
        return new HostPairsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostPortsRequestBuilder hostPorts() {
        return new HostPortsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostsRequestBuilder hosts() {
        return new HostsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostSslCertificatesRequestBuilder hostSslCertificates() {
        return new HostSslCertificatesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostTrackersRequestBuilder hostTrackers() {
        return new HostTrackersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public IntelligenceProfileIndicatorsRequestBuilder intelligenceProfileIndicators() {
        return new IntelligenceProfileIndicatorsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public IntelProfilesRequestBuilder intelProfiles() {
        return new IntelProfilesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PassiveDnsRecordsRequestBuilder passiveDnsRecords() {
        return new PassiveDnsRecordsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SslCertificatesRequestBuilder sslCertificates() {
        return new SslCertificatesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SubdomainsRequestBuilder subdomains() {
        return new SubdomainsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VulnerabilitiesRequestBuilder vulnerabilities() {
        return new VulnerabilitiesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WhoisHistoryRecordsRequestBuilder whoisHistoryRecords() {
        return new WhoisHistoryRecordsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WhoisRecordsRequestBuilder whoisRecords() {
        return new WhoisRecordsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public ThreatIntelligenceRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/threatIntelligence{?%24expand,%24select}", pathParameters);
    }

    public ThreatIntelligenceRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/threatIntelligence{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public ThreatIntelligence get() {
        return this.get(null);
    }

    @Nullable
    public ThreatIntelligence get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (ThreatIntelligence)this.requestAdapter.send(requestInfo, errorMapping, ThreatIntelligence::createFromDiscriminatorValue);
    }

    @Nullable
    public ThreatIntelligence patch(@Nonnull ThreatIntelligence body) {
        return this.patch(body, null);
    }

    @Nullable
    public ThreatIntelligence patch(@Nonnull ThreatIntelligence body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (ThreatIntelligence)this.requestAdapter.send(requestInfo, errorMapping, ThreatIntelligence::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull ThreatIntelligence body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull ThreatIntelligence body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ThreatIntelligenceRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ThreatIntelligenceRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

