/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.DataSource;
import com.microsoft.graph.models.security.DataSourceScopes;
import com.microsoft.graph.models.security.EdiscoveryAddToReviewSetOperation;
import com.microsoft.graph.models.security.EdiscoveryEstimateOperation;
import com.microsoft.graph.models.security.EdiscoveryNoncustodialDataSource;
import com.microsoft.graph.models.security.Search;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EdiscoverySearch
extends Search
implements Parsable {
    public EdiscoverySearch() {
        this.setOdataType("#microsoft.graph.security.ediscoverySearch");
    }

    @Nonnull
    public static EdiscoverySearch createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EdiscoverySearch();
    }

    @Nullable
    public List<DataSource> getAdditionalSources() {
        return (List)this.backingStore.get("additionalSources");
    }

    @Nullable
    public EdiscoveryAddToReviewSetOperation getAddToReviewSetOperation() {
        return (EdiscoveryAddToReviewSetOperation)this.backingStore.get("addToReviewSetOperation");
    }

    @Nullable
    public List<DataSource> getCustodianSources() {
        return (List)this.backingStore.get("custodianSources");
    }

    @Nullable
    public EnumSet<DataSourceScopes> getDataSourceScopes() {
        return (EnumSet)this.backingStore.get("dataSourceScopes");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalSources", n -> this.setAdditionalSources(n.getCollectionOfObjectValues(DataSource::createFromDiscriminatorValue)));
        deserializerMap.put("addToReviewSetOperation", n -> this.setAddToReviewSetOperation((EdiscoveryAddToReviewSetOperation)n.getObjectValue(EdiscoveryAddToReviewSetOperation::createFromDiscriminatorValue)));
        deserializerMap.put("custodianSources", n -> this.setCustodianSources(n.getCollectionOfObjectValues(DataSource::createFromDiscriminatorValue)));
        deserializerMap.put("dataSourceScopes", n -> this.setDataSourceScopes(n.getEnumSetValue(DataSourceScopes::forValue)));
        deserializerMap.put("lastEstimateStatisticsOperation", n -> this.setLastEstimateStatisticsOperation((EdiscoveryEstimateOperation)n.getObjectValue(EdiscoveryEstimateOperation::createFromDiscriminatorValue)));
        deserializerMap.put("noncustodialSources", n -> this.setNoncustodialSources(n.getCollectionOfObjectValues(EdiscoveryNoncustodialDataSource::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public EdiscoveryEstimateOperation getLastEstimateStatisticsOperation() {
        return (EdiscoveryEstimateOperation)this.backingStore.get("lastEstimateStatisticsOperation");
    }

    @Nullable
    public List<EdiscoveryNoncustodialDataSource> getNoncustodialSources() {
        return (List)this.backingStore.get("noncustodialSources");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("additionalSources", this.getAdditionalSources());
        writer.writeObjectValue("addToReviewSetOperation", (Parsable)this.getAddToReviewSetOperation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("custodianSources", this.getCustodianSources());
        writer.writeEnumSetValue("dataSourceScopes", this.getDataSourceScopes());
        writer.writeObjectValue("lastEstimateStatisticsOperation", (Parsable)this.getLastEstimateStatisticsOperation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("noncustodialSources", this.getNoncustodialSources());
    }

    public void setAdditionalSources(@Nullable List<DataSource> value) {
        this.backingStore.set("additionalSources", value);
    }

    public void setAddToReviewSetOperation(@Nullable EdiscoveryAddToReviewSetOperation value) {
        this.backingStore.set("addToReviewSetOperation", (Object)value);
    }

    public void setCustodianSources(@Nullable List<DataSource> value) {
        this.backingStore.set("custodianSources", value);
    }

    public void setDataSourceScopes(@Nullable EnumSet<DataSourceScopes> value) {
        this.backingStore.set("dataSourceScopes", value);
    }

    public void setLastEstimateStatisticsOperation(@Nullable EdiscoveryEstimateOperation value) {
        this.backingStore.set("lastEstimateStatisticsOperation", (Object)value);
    }

    public void setNoncustodialSources(@Nullable List<EdiscoveryNoncustodialDataSource> value) {
        this.backingStore.set("noncustodialSources", value);
    }
}

