/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.TimeCardBreak;
import com.microsoft.graph.models.TimeCardEvent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TimeCardEntry
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TimeCardEntry() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TimeCardEntry createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TimeCardEntry();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<TimeCardBreak> getBreaks() {
        return (List)this.backingStore.get("breaks");
    }

    @Nullable
    public TimeCardEvent getClockInEvent() {
        return (TimeCardEvent)this.backingStore.get("clockInEvent");
    }

    @Nullable
    public TimeCardEvent getClockOutEvent() {
        return (TimeCardEvent)this.backingStore.get("clockOutEvent");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("breaks", n -> this.setBreaks(n.getCollectionOfObjectValues(TimeCardBreak::createFromDiscriminatorValue)));
        deserializerMap.put("clockInEvent", n -> this.setClockInEvent((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        deserializerMap.put("clockOutEvent", n -> this.setClockOutEvent((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("breaks", this.getBreaks());
        writer.writeObjectValue("clockInEvent", (Parsable)this.getClockInEvent(), new Parsable[0]);
        writer.writeObjectValue("clockOutEvent", (Parsable)this.getClockOutEvent(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBreaks(@Nullable List<TimeCardBreak> value) {
        this.backingStore.set("breaks", value);
    }

    public void setClockInEvent(@Nullable TimeCardEvent value) {
        this.backingStore.set("clockInEvent", (Object)value);
    }

    public void setClockOutEvent(@Nullable TimeCardEvent value) {
        this.backingStore.set("clockOutEvent", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

