/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SynchronizationProgress
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SynchronizationProgress() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SynchronizationProgress createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SynchronizationProgress();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getCompletedUnits() {
        return (Long)this.backingStore.get("completedUnits");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("completedUnits", n -> this.setCompletedUnits(n.getLongValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("progressObservationDateTime", n -> this.setProgressObservationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("totalUnits", n -> this.setTotalUnits(n.getLongValue()));
        deserializerMap.put("units", n -> this.setUnits(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getProgressObservationDateTime() {
        return (OffsetDateTime)this.backingStore.get("progressObservationDateTime");
    }

    @Nullable
    public Long getTotalUnits() {
        return (Long)this.backingStore.get("totalUnits");
    }

    @Nullable
    public String getUnits() {
        return (String)this.backingStore.get("units");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeLongValue("completedUnits", this.getCompletedUnits());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("progressObservationDateTime", this.getProgressObservationDateTime());
        writer.writeLongValue("totalUnits", this.getTotalUnits());
        writer.writeStringValue("units", this.getUnits());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCompletedUnits(@Nullable Long value) {
        this.backingStore.set("completedUnits", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProgressObservationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("progressObservationDateTime", (Object)value);
    }

    public void setTotalUnits(@Nullable Long value) {
        this.backingStore.set("totalUnits", (Object)value);
    }

    public void setUnits(@Nullable String value) {
        this.backingStore.set("units", (Object)value);
    }
}

