/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ExchangeRestoreSession;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.OneDriveForBusinessRestoreSession;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.RestoreSessionStatus;
import com.microsoft.graph.models.SharePointRestoreSession;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RestoreSessionBase
extends Entity
implements Parsable {
    @Nonnull
    public static RestoreSessionBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.exchangeRestoreSession": {
                    return new ExchangeRestoreSession();
                }
                case "#microsoft.graph.oneDriveForBusinessRestoreSession": {
                    return new OneDriveForBusinessRestoreSession();
                }
                case "#microsoft.graph.sharePointRestoreSession": {
                    return new SharePointRestoreSession();
                }
            }
        }
        return new RestoreSessionBase();
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((RestoreSessionStatus)n.getEnumValue(RestoreSessionStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public RestoreSessionStatus getStatus() {
        return (RestoreSessionStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setStatus(@Nullable RestoreSessionStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

