/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.RestorePointSearchResult;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RestorePointSearchResponse
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RestorePointSearchResponse() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RestorePointSearchResponse createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RestorePointSearchResponse();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("noResultProtectionUnitIds", n -> this.setNoResultProtectionUnitIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("searchResponseId", n -> this.setSearchResponseId(n.getStringValue()));
        deserializerMap.put("searchResults", n -> this.setSearchResults(n.getCollectionOfObjectValues(RestorePointSearchResult::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getNoResultProtectionUnitIds() {
        return (List)this.backingStore.get("noResultProtectionUnitIds");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getSearchResponseId() {
        return (String)this.backingStore.get("searchResponseId");
    }

    @Nullable
    public List<RestorePointSearchResult> getSearchResults() {
        return (List)this.backingStore.get("searchResults");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("noResultProtectionUnitIds", this.getNoResultProtectionUnitIds());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("searchResponseId", this.getSearchResponseId());
        writer.writeCollectionOfObjectValues("searchResults", this.getSearchResults());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setNoResultProtectionUnitIds(@Nullable List<String> value) {
        this.backingStore.set("noResultProtectionUnitIds", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSearchResponseId(@Nullable String value) {
        this.backingStore.set("searchResponseId", (Object)value);
    }

    public void setSearchResults(@Nullable List<RestorePointSearchResult> value) {
        this.backingStore.set("searchResults", value);
    }
}

