/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintConnector;
import com.microsoft.graph.models.PrintTaskTrigger;
import com.microsoft.graph.models.PrinterBase;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Printer
extends PrinterBase
implements Parsable {
    public Printer() {
        this.setOdataType("#microsoft.graph.printer");
    }

    @Nonnull
    public static Printer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Printer();
    }

    @Nullable
    public List<PrintConnector> getConnectors() {
        return (List)this.backingStore.get("connectors");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("connectors", n -> this.setConnectors(n.getCollectionOfObjectValues(PrintConnector::createFromDiscriminatorValue)));
        deserializerMap.put("hasPhysicalDevice", n -> this.setHasPhysicalDevice(n.getBooleanValue()));
        deserializerMap.put("isShared", n -> this.setIsShared(n.getBooleanValue()));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("registeredDateTime", n -> this.setRegisteredDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("shares", n -> this.setShares(n.getCollectionOfObjectValues(PrinterShare::createFromDiscriminatorValue)));
        deserializerMap.put("taskTriggers", n -> this.setTaskTriggers(n.getCollectionOfObjectValues(PrintTaskTrigger::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHasPhysicalDevice() {
        return (Boolean)this.backingStore.get("hasPhysicalDevice");
    }

    @Nullable
    public Boolean getIsShared() {
        return (Boolean)this.backingStore.get("isShared");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public OffsetDateTime getRegisteredDateTime() {
        return (OffsetDateTime)this.backingStore.get("registeredDateTime");
    }

    @Nullable
    public List<PrinterShare> getShares() {
        return (List)this.backingStore.get("shares");
    }

    @Nullable
    public List<PrintTaskTrigger> getTaskTriggers() {
        return (List)this.backingStore.get("taskTriggers");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("connectors", this.getConnectors());
        writer.writeBooleanValue("hasPhysicalDevice", this.getHasPhysicalDevice());
        writer.writeBooleanValue("isShared", this.getIsShared());
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeOffsetDateTimeValue("registeredDateTime", this.getRegisteredDateTime());
        writer.writeCollectionOfObjectValues("shares", this.getShares());
        writer.writeCollectionOfObjectValues("taskTriggers", this.getTaskTriggers());
    }

    public void setConnectors(@Nullable List<PrintConnector> value) {
        this.backingStore.set("connectors", value);
    }

    public void setHasPhysicalDevice(@Nullable Boolean value) {
        this.backingStore.set("hasPhysicalDevice", (Object)value);
    }

    public void setIsShared(@Nullable Boolean value) {
        this.backingStore.set("isShared", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setRegisteredDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("registeredDateTime", (Object)value);
    }

    public void setShares(@Nullable List<PrinterShare> value) {
        this.backingStore.set("shares", value);
    }

    public void setTaskTriggers(@Nullable List<PrintTaskTrigger> value) {
        this.backingStore.set("taskTriggers", value);
    }
}

