/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PrintDocument;
import com.microsoft.graph.models.PrintJobConfiguration;
import com.microsoft.graph.models.PrintJobStatus;
import com.microsoft.graph.models.PrintTask;
import com.microsoft.graph.models.UserIdentity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrintJob
extends Entity
implements Parsable {
    @Nonnull
    public static PrintJob createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrintJob();
    }

    @Nullable
    public OffsetDateTime getAcknowledgedDateTime() {
        return (OffsetDateTime)this.backingStore.get("acknowledgedDateTime");
    }

    @Nullable
    public PrintJobConfiguration getConfiguration() {
        return (PrintJobConfiguration)this.backingStore.get("configuration");
    }

    @Nullable
    public UserIdentity getCreatedBy() {
        return (UserIdentity)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<PrintDocument> getDocuments() {
        return (List)this.backingStore.get("documents");
    }

    @Nullable
    public Integer getErrorCode() {
        return (Integer)this.backingStore.get("errorCode");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("acknowledgedDateTime", n -> this.setAcknowledgedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("configuration", n -> this.setConfiguration((PrintJobConfiguration)n.getObjectValue(PrintJobConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((UserIdentity)n.getObjectValue(UserIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("documents", n -> this.setDocuments(n.getCollectionOfObjectValues(PrintDocument::createFromDiscriminatorValue)));
        deserializerMap.put("errorCode", n -> this.setErrorCode(n.getIntegerValue()));
        deserializerMap.put("isFetchable", n -> this.setIsFetchable(n.getBooleanValue()));
        deserializerMap.put("redirectedFrom", n -> this.setRedirectedFrom(n.getStringValue()));
        deserializerMap.put("redirectedTo", n -> this.setRedirectedTo(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((PrintJobStatus)n.getObjectValue(PrintJobStatus::createFromDiscriminatorValue)));
        deserializerMap.put("tasks", n -> this.setTasks(n.getCollectionOfObjectValues(PrintTask::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsFetchable() {
        return (Boolean)this.backingStore.get("isFetchable");
    }

    @Nullable
    public String getRedirectedFrom() {
        return (String)this.backingStore.get("redirectedFrom");
    }

    @Nullable
    public String getRedirectedTo() {
        return (String)this.backingStore.get("redirectedTo");
    }

    @Nullable
    public PrintJobStatus getStatus() {
        return (PrintJobStatus)this.backingStore.get("status");
    }

    @Nullable
    public List<PrintTask> getTasks() {
        return (List)this.backingStore.get("tasks");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("acknowledgedDateTime", this.getAcknowledgedDateTime());
        writer.writeObjectValue("configuration", (Parsable)this.getConfiguration(), new Parsable[0]);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("documents", this.getDocuments());
        writer.writeIntegerValue("errorCode", this.getErrorCode());
        writer.writeBooleanValue("isFetchable", this.getIsFetchable());
        writer.writeStringValue("redirectedFrom", this.getRedirectedFrom());
        writer.writeStringValue("redirectedTo", this.getRedirectedTo());
        writer.writeObjectValue("status", (Parsable)this.getStatus(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("tasks", this.getTasks());
    }

    public void setAcknowledgedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("acknowledgedDateTime", (Object)value);
    }

    public void setConfiguration(@Nullable PrintJobConfiguration value) {
        this.backingStore.set("configuration", (Object)value);
    }

    public void setCreatedBy(@Nullable UserIdentity value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDocuments(@Nullable List<PrintDocument> value) {
        this.backingStore.set("documents", value);
    }

    public void setErrorCode(@Nullable Integer value) {
        this.backingStore.set("errorCode", (Object)value);
    }

    public void setIsFetchable(@Nullable Boolean value) {
        this.backingStore.set("isFetchable", (Object)value);
    }

    public void setRedirectedFrom(@Nullable String value) {
        this.backingStore.set("redirectedFrom", (Object)value);
    }

    public void setRedirectedTo(@Nullable String value) {
        this.backingStore.set("redirectedTo", (Object)value);
    }

    public void setStatus(@Nullable PrintJobStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setTasks(@Nullable List<PrintTask> value) {
        this.backingStore.set("tasks", value);
    }
}

