/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.MessageActionFlag;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.Sensitivity;
import com.microsoft.graph.models.SizeRange;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MessageRulePredicates
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MessageRulePredicates() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MessageRulePredicates createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MessageRulePredicates();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<String> getBodyContains() {
        return (List)this.backingStore.get("bodyContains");
    }

    @Nullable
    public List<String> getBodyOrSubjectContains() {
        return (List)this.backingStore.get("bodyOrSubjectContains");
    }

    @Nullable
    public List<String> getCategories() {
        return (List)this.backingStore.get("categories");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(31);
        deserializerMap.put("bodyContains", n -> this.setBodyContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("bodyOrSubjectContains", n -> this.setBodyOrSubjectContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("categories", n -> this.setCategories(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("fromAddresses", n -> this.setFromAddresses(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("headerContains", n -> this.setHeaderContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("importance", n -> this.setImportance((Importance)n.getEnumValue(Importance::forValue)));
        deserializerMap.put("isApprovalRequest", n -> this.setIsApprovalRequest(n.getBooleanValue()));
        deserializerMap.put("isAutomaticForward", n -> this.setIsAutomaticForward(n.getBooleanValue()));
        deserializerMap.put("isAutomaticReply", n -> this.setIsAutomaticReply(n.getBooleanValue()));
        deserializerMap.put("isEncrypted", n -> this.setIsEncrypted(n.getBooleanValue()));
        deserializerMap.put("isMeetingRequest", n -> this.setIsMeetingRequest(n.getBooleanValue()));
        deserializerMap.put("isMeetingResponse", n -> this.setIsMeetingResponse(n.getBooleanValue()));
        deserializerMap.put("isNonDeliveryReport", n -> this.setIsNonDeliveryReport(n.getBooleanValue()));
        deserializerMap.put("isPermissionControlled", n -> this.setIsPermissionControlled(n.getBooleanValue()));
        deserializerMap.put("isReadReceipt", n -> this.setIsReadReceipt(n.getBooleanValue()));
        deserializerMap.put("isSigned", n -> this.setIsSigned(n.getBooleanValue()));
        deserializerMap.put("isVoicemail", n -> this.setIsVoicemail(n.getBooleanValue()));
        deserializerMap.put("messageActionFlag", n -> this.setMessageActionFlag((MessageActionFlag)n.getEnumValue(MessageActionFlag::forValue)));
        deserializerMap.put("notSentToMe", n -> this.setNotSentToMe(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recipientContains", n -> this.setRecipientContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("senderContains", n -> this.setSenderContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("sensitivity", n -> this.setSensitivity((Sensitivity)n.getEnumValue(Sensitivity::forValue)));
        deserializerMap.put("sentCcMe", n -> this.setSentCcMe(n.getBooleanValue()));
        deserializerMap.put("sentOnlyToMe", n -> this.setSentOnlyToMe(n.getBooleanValue()));
        deserializerMap.put("sentToAddresses", n -> this.setSentToAddresses(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("sentToMe", n -> this.setSentToMe(n.getBooleanValue()));
        deserializerMap.put("sentToOrCcMe", n -> this.setSentToOrCcMe(n.getBooleanValue()));
        deserializerMap.put("subjectContains", n -> this.setSubjectContains(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("withinSizeRange", n -> this.setWithinSizeRange((SizeRange)n.getObjectValue(SizeRange::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<Recipient> getFromAddresses() {
        return (List)this.backingStore.get("fromAddresses");
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public List<String> getHeaderContains() {
        return (List)this.backingStore.get("headerContains");
    }

    @Nullable
    public Importance getImportance() {
        return (Importance)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public Boolean getIsApprovalRequest() {
        return (Boolean)this.backingStore.get("isApprovalRequest");
    }

    @Nullable
    public Boolean getIsAutomaticForward() {
        return (Boolean)this.backingStore.get("isAutomaticForward");
    }

    @Nullable
    public Boolean getIsAutomaticReply() {
        return (Boolean)this.backingStore.get("isAutomaticReply");
    }

    @Nullable
    public Boolean getIsEncrypted() {
        return (Boolean)this.backingStore.get("isEncrypted");
    }

    @Nullable
    public Boolean getIsMeetingRequest() {
        return (Boolean)this.backingStore.get("isMeetingRequest");
    }

    @Nullable
    public Boolean getIsMeetingResponse() {
        return (Boolean)this.backingStore.get("isMeetingResponse");
    }

    @Nullable
    public Boolean getIsNonDeliveryReport() {
        return (Boolean)this.backingStore.get("isNonDeliveryReport");
    }

    @Nullable
    public Boolean getIsPermissionControlled() {
        return (Boolean)this.backingStore.get("isPermissionControlled");
    }

    @Nullable
    public Boolean getIsReadReceipt() {
        return (Boolean)this.backingStore.get("isReadReceipt");
    }

    @Nullable
    public Boolean getIsSigned() {
        return (Boolean)this.backingStore.get("isSigned");
    }

    @Nullable
    public Boolean getIsVoicemail() {
        return (Boolean)this.backingStore.get("isVoicemail");
    }

    @Nullable
    public MessageActionFlag getMessageActionFlag() {
        return (MessageActionFlag)((Object)this.backingStore.get("messageActionFlag"));
    }

    @Nullable
    public Boolean getNotSentToMe() {
        return (Boolean)this.backingStore.get("notSentToMe");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<String> getRecipientContains() {
        return (List)this.backingStore.get("recipientContains");
    }

    @Nullable
    public List<String> getSenderContains() {
        return (List)this.backingStore.get("senderContains");
    }

    @Nullable
    public Sensitivity getSensitivity() {
        return (Sensitivity)((Object)this.backingStore.get("sensitivity"));
    }

    @Nullable
    public Boolean getSentCcMe() {
        return (Boolean)this.backingStore.get("sentCcMe");
    }

    @Nullable
    public Boolean getSentOnlyToMe() {
        return (Boolean)this.backingStore.get("sentOnlyToMe");
    }

    @Nullable
    public List<Recipient> getSentToAddresses() {
        return (List)this.backingStore.get("sentToAddresses");
    }

    @Nullable
    public Boolean getSentToMe() {
        return (Boolean)this.backingStore.get("sentToMe");
    }

    @Nullable
    public Boolean getSentToOrCcMe() {
        return (Boolean)this.backingStore.get("sentToOrCcMe");
    }

    @Nullable
    public List<String> getSubjectContains() {
        return (List)this.backingStore.get("subjectContains");
    }

    @Nullable
    public SizeRange getWithinSizeRange() {
        return (SizeRange)this.backingStore.get("withinSizeRange");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("bodyContains", this.getBodyContains());
        writer.writeCollectionOfPrimitiveValues("bodyOrSubjectContains", this.getBodyOrSubjectContains());
        writer.writeCollectionOfPrimitiveValues("categories", this.getCategories());
        writer.writeCollectionOfObjectValues("fromAddresses", this.getFromAddresses());
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeCollectionOfPrimitiveValues("headerContains", this.getHeaderContains());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeBooleanValue("isApprovalRequest", this.getIsApprovalRequest());
        writer.writeBooleanValue("isAutomaticForward", this.getIsAutomaticForward());
        writer.writeBooleanValue("isAutomaticReply", this.getIsAutomaticReply());
        writer.writeBooleanValue("isEncrypted", this.getIsEncrypted());
        writer.writeBooleanValue("isMeetingRequest", this.getIsMeetingRequest());
        writer.writeBooleanValue("isMeetingResponse", this.getIsMeetingResponse());
        writer.writeBooleanValue("isNonDeliveryReport", this.getIsNonDeliveryReport());
        writer.writeBooleanValue("isPermissionControlled", this.getIsPermissionControlled());
        writer.writeBooleanValue("isReadReceipt", this.getIsReadReceipt());
        writer.writeBooleanValue("isSigned", this.getIsSigned());
        writer.writeBooleanValue("isVoicemail", this.getIsVoicemail());
        writer.writeEnumValue("messageActionFlag", (Enum)this.getMessageActionFlag());
        writer.writeBooleanValue("notSentToMe", this.getNotSentToMe());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfPrimitiveValues("recipientContains", this.getRecipientContains());
        writer.writeCollectionOfPrimitiveValues("senderContains", this.getSenderContains());
        writer.writeEnumValue("sensitivity", (Enum)this.getSensitivity());
        writer.writeBooleanValue("sentCcMe", this.getSentCcMe());
        writer.writeBooleanValue("sentOnlyToMe", this.getSentOnlyToMe());
        writer.writeCollectionOfObjectValues("sentToAddresses", this.getSentToAddresses());
        writer.writeBooleanValue("sentToMe", this.getSentToMe());
        writer.writeBooleanValue("sentToOrCcMe", this.getSentToOrCcMe());
        writer.writeCollectionOfPrimitiveValues("subjectContains", this.getSubjectContains());
        writer.writeObjectValue("withinSizeRange", (Parsable)this.getWithinSizeRange(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBodyContains(@Nullable List<String> value) {
        this.backingStore.set("bodyContains", value);
    }

    public void setBodyOrSubjectContains(@Nullable List<String> value) {
        this.backingStore.set("bodyOrSubjectContains", value);
    }

    public void setCategories(@Nullable List<String> value) {
        this.backingStore.set("categories", value);
    }

    public void setFromAddresses(@Nullable List<Recipient> value) {
        this.backingStore.set("fromAddresses", value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setHeaderContains(@Nullable List<String> value) {
        this.backingStore.set("headerContains", value);
    }

    public void setImportance(@Nullable Importance value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setIsApprovalRequest(@Nullable Boolean value) {
        this.backingStore.set("isApprovalRequest", (Object)value);
    }

    public void setIsAutomaticForward(@Nullable Boolean value) {
        this.backingStore.set("isAutomaticForward", (Object)value);
    }

    public void setIsAutomaticReply(@Nullable Boolean value) {
        this.backingStore.set("isAutomaticReply", (Object)value);
    }

    public void setIsEncrypted(@Nullable Boolean value) {
        this.backingStore.set("isEncrypted", (Object)value);
    }

    public void setIsMeetingRequest(@Nullable Boolean value) {
        this.backingStore.set("isMeetingRequest", (Object)value);
    }

    public void setIsMeetingResponse(@Nullable Boolean value) {
        this.backingStore.set("isMeetingResponse", (Object)value);
    }

    public void setIsNonDeliveryReport(@Nullable Boolean value) {
        this.backingStore.set("isNonDeliveryReport", (Object)value);
    }

    public void setIsPermissionControlled(@Nullable Boolean value) {
        this.backingStore.set("isPermissionControlled", (Object)value);
    }

    public void setIsReadReceipt(@Nullable Boolean value) {
        this.backingStore.set("isReadReceipt", (Object)value);
    }

    public void setIsSigned(@Nullable Boolean value) {
        this.backingStore.set("isSigned", (Object)value);
    }

    public void setIsVoicemail(@Nullable Boolean value) {
        this.backingStore.set("isVoicemail", (Object)value);
    }

    public void setMessageActionFlag(@Nullable MessageActionFlag value) {
        this.backingStore.set("messageActionFlag", (Object)value);
    }

    public void setNotSentToMe(@Nullable Boolean value) {
        this.backingStore.set("notSentToMe", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecipientContains(@Nullable List<String> value) {
        this.backingStore.set("recipientContains", value);
    }

    public void setSenderContains(@Nullable List<String> value) {
        this.backingStore.set("senderContains", value);
    }

    public void setSensitivity(@Nullable Sensitivity value) {
        this.backingStore.set("sensitivity", (Object)value);
    }

    public void setSentCcMe(@Nullable Boolean value) {
        this.backingStore.set("sentCcMe", (Object)value);
    }

    public void setSentOnlyToMe(@Nullable Boolean value) {
        this.backingStore.set("sentOnlyToMe", (Object)value);
    }

    public void setSentToAddresses(@Nullable List<Recipient> value) {
        this.backingStore.set("sentToAddresses", value);
    }

    public void setSentToMe(@Nullable Boolean value) {
        this.backingStore.set("sentToMe", (Object)value);
    }

    public void setSentToOrCcMe(@Nullable Boolean value) {
        this.backingStore.set("sentToOrCcMe", (Object)value);
    }

    public void setSubjectContains(@Nullable List<String> value) {
        this.backingStore.set("subjectContains", value);
    }

    public void setWithinSizeRange(@Nullable SizeRange value) {
        this.backingStore.set("withinSizeRange", (Object)value);
    }
}

