/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IosNotificationAlertType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IosNotificationSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public IosNotificationSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static IosNotificationSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IosNotificationSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public IosNotificationAlertType getAlertType() {
        return (IosNotificationAlertType)((Object)this.backingStore.get("alertType"));
    }

    @Nullable
    public String getAppName() {
        return (String)this.backingStore.get("appName");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getBadgesEnabled() {
        return (Boolean)this.backingStore.get("badgesEnabled");
    }

    @Nullable
    public String getBundleID() {
        return (String)this.backingStore.get("bundleID");
    }

    @Nullable
    public Boolean getEnabled() {
        return (Boolean)this.backingStore.get("enabled");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("alertType", n -> this.setAlertType((IosNotificationAlertType)n.getEnumValue(IosNotificationAlertType::forValue)));
        deserializerMap.put("appName", n -> this.setAppName(n.getStringValue()));
        deserializerMap.put("badgesEnabled", n -> this.setBadgesEnabled(n.getBooleanValue()));
        deserializerMap.put("bundleID", n -> this.setBundleID(n.getStringValue()));
        deserializerMap.put("enabled", n -> this.setEnabled(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("publisher", n -> this.setPublisher(n.getStringValue()));
        deserializerMap.put("showInNotificationCenter", n -> this.setShowInNotificationCenter(n.getBooleanValue()));
        deserializerMap.put("showOnLockScreen", n -> this.setShowOnLockScreen(n.getBooleanValue()));
        deserializerMap.put("soundsEnabled", n -> this.setSoundsEnabled(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPublisher() {
        return (String)this.backingStore.get("publisher");
    }

    @Nullable
    public Boolean getShowInNotificationCenter() {
        return (Boolean)this.backingStore.get("showInNotificationCenter");
    }

    @Nullable
    public Boolean getShowOnLockScreen() {
        return (Boolean)this.backingStore.get("showOnLockScreen");
    }

    @Nullable
    public Boolean getSoundsEnabled() {
        return (Boolean)this.backingStore.get("soundsEnabled");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("alertType", (Enum)this.getAlertType());
        writer.writeStringValue("appName", this.getAppName());
        writer.writeBooleanValue("badgesEnabled", this.getBadgesEnabled());
        writer.writeStringValue("bundleID", this.getBundleID());
        writer.writeBooleanValue("enabled", this.getEnabled());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("publisher", this.getPublisher());
        writer.writeBooleanValue("showInNotificationCenter", this.getShowInNotificationCenter());
        writer.writeBooleanValue("showOnLockScreen", this.getShowOnLockScreen());
        writer.writeBooleanValue("soundsEnabled", this.getSoundsEnabled());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAlertType(@Nullable IosNotificationAlertType value) {
        this.backingStore.set("alertType", (Object)value);
    }

    public void setAppName(@Nullable String value) {
        this.backingStore.set("appName", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBadgesEnabled(@Nullable Boolean value) {
        this.backingStore.set("badgesEnabled", (Object)value);
    }

    public void setBundleID(@Nullable String value) {
        this.backingStore.set("bundleID", (Object)value);
    }

    public void setEnabled(@Nullable Boolean value) {
        this.backingStore.set("enabled", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPublisher(@Nullable String value) {
        this.backingStore.set("publisher", (Object)value);
    }

    public void setShowInNotificationCenter(@Nullable Boolean value) {
        this.backingStore.set("showInNotificationCenter", (Object)value);
    }

    public void setShowOnLockScreen(@Nullable Boolean value) {
        this.backingStore.set("showOnLockScreen", (Object)value);
    }

    public void setSoundsEnabled(@Nullable Boolean value) {
        this.backingStore.set("soundsEnabled", (Object)value);
    }
}

