/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.models.ChatMessageInfo;
import com.microsoft.graph.models.ChatType;
import com.microsoft.graph.models.ChatViewpoint;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PinnedChatMessageInfo;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import com.microsoft.graph.models.TeamsAppInstallation;
import com.microsoft.graph.models.TeamsTab;
import com.microsoft.graph.models.TeamworkOnlineMeetingInfo;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Chat
extends Entity
implements Parsable {
    @Nonnull
    public static Chat createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Chat();
    }

    @Nullable
    public ChatType getChatType() {
        return (ChatType)((Object)this.backingStore.get("chatType"));
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("chatType", n -> this.setChatType((ChatType)n.getEnumValue(ChatType::forValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("installedApps", n -> this.setInstalledApps(n.getCollectionOfObjectValues(TeamsAppInstallation::createFromDiscriminatorValue)));
        deserializerMap.put("isHiddenForAllMembers", n -> this.setIsHiddenForAllMembers(n.getBooleanValue()));
        deserializerMap.put("lastMessagePreview", n -> this.setLastMessagePreview((ChatMessageInfo)n.getObjectValue(ChatMessageInfo::createFromDiscriminatorValue)));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(ConversationMember::createFromDiscriminatorValue)));
        deserializerMap.put("messages", n -> this.setMessages(n.getCollectionOfObjectValues(ChatMessage::createFromDiscriminatorValue)));
        deserializerMap.put("onlineMeetingInfo", n -> this.setOnlineMeetingInfo((TeamworkOnlineMeetingInfo)n.getObjectValue(TeamworkOnlineMeetingInfo::createFromDiscriminatorValue)));
        deserializerMap.put("permissionGrants", n -> this.setPermissionGrants(n.getCollectionOfObjectValues(ResourceSpecificPermissionGrant::createFromDiscriminatorValue)));
        deserializerMap.put("pinnedMessages", n -> this.setPinnedMessages(n.getCollectionOfObjectValues(PinnedChatMessageInfo::createFromDiscriminatorValue)));
        deserializerMap.put("tabs", n -> this.setTabs(n.getCollectionOfObjectValues(TeamsTab::createFromDiscriminatorValue)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        deserializerMap.put("topic", n -> this.setTopic(n.getStringValue()));
        deserializerMap.put("viewpoint", n -> this.setViewpoint((ChatViewpoint)n.getObjectValue(ChatViewpoint::createFromDiscriminatorValue)));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<TeamsAppInstallation> getInstalledApps() {
        return (List)this.backingStore.get("installedApps");
    }

    @Nullable
    public Boolean getIsHiddenForAllMembers() {
        return (Boolean)this.backingStore.get("isHiddenForAllMembers");
    }

    @Nullable
    public ChatMessageInfo getLastMessagePreview() {
        return (ChatMessageInfo)this.backingStore.get("lastMessagePreview");
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public List<ConversationMember> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public List<ChatMessage> getMessages() {
        return (List)this.backingStore.get("messages");
    }

    @Nullable
    public TeamworkOnlineMeetingInfo getOnlineMeetingInfo() {
        return (TeamworkOnlineMeetingInfo)this.backingStore.get("onlineMeetingInfo");
    }

    @Nullable
    public List<ResourceSpecificPermissionGrant> getPermissionGrants() {
        return (List)this.backingStore.get("permissionGrants");
    }

    @Nullable
    public List<PinnedChatMessageInfo> getPinnedMessages() {
        return (List)this.backingStore.get("pinnedMessages");
    }

    @Nullable
    public List<TeamsTab> getTabs() {
        return (List)this.backingStore.get("tabs");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Nullable
    public String getTopic() {
        return (String)this.backingStore.get("topic");
    }

    @Nullable
    public ChatViewpoint getViewpoint() {
        return (ChatViewpoint)this.backingStore.get("viewpoint");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("chatType", (Enum)this.getChatType());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("installedApps", this.getInstalledApps());
        writer.writeBooleanValue("isHiddenForAllMembers", this.getIsHiddenForAllMembers());
        writer.writeObjectValue("lastMessagePreview", (Parsable)this.getLastMessagePreview(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeCollectionOfObjectValues("messages", this.getMessages());
        writer.writeObjectValue("onlineMeetingInfo", (Parsable)this.getOnlineMeetingInfo(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("permissionGrants", this.getPermissionGrants());
        writer.writeCollectionOfObjectValues("pinnedMessages", this.getPinnedMessages());
        writer.writeCollectionOfObjectValues("tabs", this.getTabs());
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeStringValue("topic", this.getTopic());
        writer.writeObjectValue("viewpoint", (Parsable)this.getViewpoint(), new Parsable[0]);
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setChatType(@Nullable ChatType value) {
        this.backingStore.set("chatType", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setInstalledApps(@Nullable List<TeamsAppInstallation> value) {
        this.backingStore.set("installedApps", value);
    }

    public void setIsHiddenForAllMembers(@Nullable Boolean value) {
        this.backingStore.set("isHiddenForAllMembers", (Object)value);
    }

    public void setLastMessagePreview(@Nullable ChatMessageInfo value) {
        this.backingStore.set("lastMessagePreview", (Object)value);
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setMembers(@Nullable List<ConversationMember> value) {
        this.backingStore.set("members", value);
    }

    public void setMessages(@Nullable List<ChatMessage> value) {
        this.backingStore.set("messages", value);
    }

    public void setOnlineMeetingInfo(@Nullable TeamworkOnlineMeetingInfo value) {
        this.backingStore.set("onlineMeetingInfo", (Object)value);
    }

    public void setPermissionGrants(@Nullable List<ResourceSpecificPermissionGrant> value) {
        this.backingStore.set("permissionGrants", value);
    }

    public void setPinnedMessages(@Nullable List<PinnedChatMessageInfo> value) {
        this.backingStore.set("pinnedMessages", value);
    }

    public void setTabs(@Nullable List<TeamsTab> value) {
        this.backingStore.set("tabs", value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }

    public void setTopic(@Nullable String value) {
        this.backingStore.set("topic", (Object)value);
    }

    public void setViewpoint(@Nullable ChatViewpoint value) {
        this.backingStore.set("viewpoint", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

