/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.core.models.EncryptedContentBearer;
import com.microsoft.graph.models.ChangeNotificationEncryptedContent;
import com.microsoft.graph.models.ChangeType;
import com.microsoft.graph.models.LifecycleEventType;
import com.microsoft.graph.models.ResourceData;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ChangeNotification
implements EncryptedContentBearer<ChangeNotificationEncryptedContent>,
AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ChangeNotification() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ChangeNotification createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ChangeNotification();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ChangeType getChangeType() {
        return (ChangeType)((Object)this.backingStore.get("changeType"));
    }

    @Nullable
    public String getClientState() {
        return (String)this.backingStore.get("clientState");
    }

    @Nullable
    public ChangeNotificationEncryptedContent getEncryptedContent() {
        return (ChangeNotificationEncryptedContent)this.backingStore.get("encryptedContent");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(11);
        deserializerMap.put("changeType", n -> this.setChangeType((ChangeType)n.getEnumValue(ChangeType::forValue)));
        deserializerMap.put("clientState", n -> this.setClientState(n.getStringValue()));
        deserializerMap.put("encryptedContent", n -> this.setEncryptedContent((ChangeNotificationEncryptedContent)n.getObjectValue(ChangeNotificationEncryptedContent::createFromDiscriminatorValue)));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("lifecycleEvent", n -> this.setLifecycleEvent((LifecycleEventType)n.getEnumValue(LifecycleEventType::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("resource", n -> this.setResource(n.getStringValue()));
        deserializerMap.put("resourceData", n -> this.setResourceData((ResourceData)n.getObjectValue(ResourceData::createFromDiscriminatorValue)));
        deserializerMap.put("subscriptionExpirationDateTime", n -> this.setSubscriptionExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("subscriptionId", n -> this.setSubscriptionId(n.getStringValue()));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public LifecycleEventType getLifecycleEvent() {
        return (LifecycleEventType)((Object)this.backingStore.get("lifecycleEvent"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getResource() {
        return (String)this.backingStore.get("resource");
    }

    @Nullable
    public ResourceData getResourceData() {
        return (ResourceData)this.backingStore.get("resourceData");
    }

    @Nullable
    public OffsetDateTime getSubscriptionExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("subscriptionExpirationDateTime");
    }

    @Nullable
    public String getSubscriptionId() {
        return (String)this.backingStore.get("subscriptionId");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("changeType", (Enum)this.getChangeType());
        writer.writeStringValue("clientState", this.getClientState());
        writer.writeObjectValue("encryptedContent", (Parsable)this.getEncryptedContent(), new Parsable[0]);
        writer.writeStringValue("id", this.getId());
        writer.writeEnumValue("lifecycleEvent", (Enum)this.getLifecycleEvent());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("resource", this.getResource());
        writer.writeObjectValue("resourceData", (Parsable)this.getResourceData(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("subscriptionExpirationDateTime", this.getSubscriptionExpirationDateTime());
        writer.writeStringValue("subscriptionId", this.getSubscriptionId());
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setChangeType(@Nullable ChangeType value) {
        this.backingStore.set("changeType", (Object)value);
    }

    public void setClientState(@Nullable String value) {
        this.backingStore.set("clientState", (Object)value);
    }

    public void setEncryptedContent(@Nullable ChangeNotificationEncryptedContent value) {
        this.backingStore.set("encryptedContent", (Object)value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setLifecycleEvent(@Nullable LifecycleEventType value) {
        this.backingStore.set("lifecycleEvent", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setResource(@Nullable String value) {
        this.backingStore.set("resource", (Object)value);
    }

    public void setResourceData(@Nullable ResourceData value) {
        this.backingStore.set("resourceData", (Object)value);
    }

    public void setSubscriptionExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("subscriptionExpirationDateTime", (Object)value);
    }

    public void setSubscriptionId(@Nullable String value) {
        this.backingStore.set("subscriptionId", (Object)value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }
}

